/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import com.google.common.collect.Lists;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.generators.GuiConductorMast;
import sonar.calculator.mod.common.containers.ContainerConductorMast;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.common.tileentity.machines.TileEntityTransmitter;
import sonar.calculator.mod.common.tileentity.machines.TileEntityWeatherStation;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IGuiTile;

public class TileEntityConductorMast
extends TileEntityEnergyInventory
implements ISidedInventory,
IProcessMachine,
IGuiTile {
    public final SyncTagType.INT cookTime = new SyncTagType.INT(0);
    public final SyncTagType.INT lightningSpeed = new SyncTagType.INT(1);
    public final SyncTagType.INT lightTicks = new SyncTagType.INT(2);
    public final SyncTagType.INT lightingTicks = new SyncTagType.INT(3);
    public final SyncTagType.INT random = new SyncTagType.INT(4);
    public final SyncTagType.INT rfPerStrike = new SyncTagType.INT(5);
    public final SyncTagType.DOUBLE rfPerTick = new SyncTagType.DOUBLE(6);
    public int lastStations;
    public int strikes;
    public int avgTicks;
    public static int furnaceSpeed = 50;
    public final int weatherStationRF = CalculatorConfig.getInteger("Weather Station");
    public final int strikeRF = CalculatorConfig.getInteger("Conductor Mast");
    public Random rand = new Random();

    public TileEntityConductorMast() {
        this.storage.setCapacity(50000000).setMaxTransfer(64000);
        this.inv = new SonarInventory((TileEntity)this, 2);
        this.maxTransfer = 5000000;
        this.energyMode = EnergyMode.SEND;
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncTagType[]{this.cookTime, this.lightingTicks, this.lightTicks, this.lightningSpeed, this.random, this.rfPerStrike, this.rfPerTick}));
    }

    public ItemStack recipeOutput(ItemStack stack) {
        return RecipeRegistry.ConductorMastItemRecipes.instance().getCraftingResult(new ItemStack[]{stack});
    }

    public int recipeEnergy(ItemStack stack) {
        return RecipeRegistry.ConductorMastPowerRecipes.instance().getPowercost(stack);
    }

    public void onLoaded() {
        TileEntityConductorMast.setWeatherStationAngles(true, this.field_145850_b, this.field_174879_c);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if ((Integer)this.cookTime.getObject() > 0) {
            this.cookTime.increaseBy(1);
        }
        if (this.canCook()) {
            if ((Integer)this.cookTime.getObject() == 0) {
                this.cookTime.increaseBy(1);
            }
            if ((Integer)this.cookTime.getObject() == furnaceSpeed) {
                this.cookTime.setObject((Object)0);
                this.cookItem();
            }
        } else {
            this.cookTime.setObject((Object)0);
        }
        if (this.storage.getMaxEnergyStored() != this.storage.getEnergyStored() && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && (Integer)this.lightningSpeed.getObject() == 0) {
            this.random.setObject((Object)((int)(Math.random() * 9.0)));
            this.lightningSpeed.setObject((Object)(this.rand.nextInt(300) + this.getNextTime()));
        }
        if ((Integer)this.lightningSpeed.getObject() > 0) {
            if ((Integer)this.lightingTicks.getObject() >= (Integer)this.lightningSpeed.getObject()) {
                int lastSpeed = (Integer)this.lightningSpeed.getObject();
                this.lightingTicks.setObject((Object)0);
                this.lightningSpeed.setObject((Object)0);
                this.strikes = this.getStrikes();
                if (this.isClient()) {
                    for (int currentstrikes = this.strikes > 5 ? 5 : this.strikes; currentstrikes != 0; --currentstrikes) {
                        this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 4), (double)this.field_174879_c.func_177952_p(), true));
                    }
                }
                this.lastStations = this.getStations();
                this.lightTicks.increaseBy(1);
                if (this.isServer()) {
                    this.rfPerStrike.setObject((Object)((this.strikeRF / 200 + this.lastStations * (this.weatherStationRF / 200)) * this.strikes * 4 * 200));
                    this.rfPerTick.setObject((Object)((double)((Integer)this.rfPerStrike.getObject()).intValue() / (double)lastSpeed));
                }
            } else {
                this.lightingTicks.increaseBy(1);
            }
        }
        if ((Integer)this.lightTicks.getObject() > 0) {
            int add = (this.strikeRF / 200 + this.lastStations * (this.weatherStationRF / 200)) * this.strikes * 4;
            if ((Integer)this.lightTicks.getObject() < 200) {
                if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                    this.lightTicks.increaseBy(1);
                    this.storage.receiveEnergy(add, false);
                } else {
                    this.lightTicks.increaseBy(1);
                    this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
                }
            } else if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                this.lightTicks.setObject((Object)0);
                this.storage.receiveEnergy(add, false);
            } else {
                this.lightTicks.increaseBy(1);
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
        }
        this.addEnergy(new EnumFacing[]{EnumFacing.DOWN});
        this.func_70296_d();
    }

    private void lightningStrike(World world, int x, int y, int z) {
        if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z, true));
        }
    }

    public boolean canCook() {
        if (this.storage.getEnergyStored() == 0) {
            return false;
        }
        if (this.slots()[0] == null) {
            return false;
        }
        if ((Integer)this.cookTime.getObject() >= furnaceSpeed) {
            return true;
        }
        ItemStack itemstack = this.recipeOutput(this.slots()[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.slots()[1] != null) {
            if (!this.slots()[1].func_77969_a(itemstack)) {
                return false;
            }
            if (this.slots()[1].field_77994_a + itemstack.field_77994_a > this.slots()[1].func_77976_d()) {
                return false;
            }
        }
        int itemEnergy = this.recipeEnergy(this.slots()[0]);
        return (Integer)this.cookTime.getObject() != 0 || this.storage.getEnergyStored() >= itemEnergy;
    }

    private void cookItem() {
        ItemStack itemstack = this.recipeOutput(this.slots()[0]);
        int energy = this.recipeEnergy(this.slots()[0]);
        this.storage.extractEnergy(energy, false);
        if (this.slots()[1] == null) {
            this.slots()[1] = itemstack.func_77946_l();
        } else if (this.slots()[1].func_77969_a(itemstack)) {
            ++this.slots()[1].field_77994_a;
        }
        --this.slots()[0].field_77994_a;
        if (this.slots()[0].field_77994_a <= 0) {
            this.slots()[0] = null;
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.lastStations = nbt.func_74762_e("lastStations");
            this.strikes = nbt.func_74762_e("strikes");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("lastStations", this.lastStations);
            nbt.func_74768_a("strikes", this.strikes);
        }
        return nbt;
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        if (side == EnumFacing.DOWN) {
            return EnergyMode.SEND;
        }
        return EnergyMode.BLOCKED;
    }

    public static void setWeatherStationAngles(boolean packet, World world, BlockPos pos) {
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                TileEntity target = world.func_175625_s(pos.func_177982_a(x, 0, z));
                if (target == null || !(target instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)target;
                station.setAngle();
                station.markBlockForUpdate();
            }
        }
    }

    public int getStations() {
        int stations = 0;
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(x, 0, z));
                if (target == null || !(target instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)target;
                if (station.x != this.field_174879_c.func_177958_n() || station.z != this.field_174879_c.func_177952_p()) continue;
                ++stations;
            }
        }
        return stations;
    }

    public int getStrikes() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return trans / 4;
            }
            return 1;
        }
        return 1;
    }

    public int getNextTime() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return 250;
            }
            return 1500 - 135 * trans;
        }
        return 1500;
    }

    public int getTransmitters() {
        int transmitter = 0;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(x, 0, z));
                if (target == null || !(target instanceof TileEntityTransmitter)) continue;
                TileEntityTransmitter station = (TileEntityTransmitter)target;
                ++transmitter;
            }
        }
        return transmitter;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        if (slot == 0) {
            return stack != null && this.recipeOutput(stack) != null;
        }
        return true;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return slot == 1;
    }

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        return furnaceSpeed;
    }

    public double getEnergyUsage() {
        if (this.slots()[0] != null) {
            return this.recipeEnergy(this.slots()[0]);
        }
        return 0.0;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerConductorMast(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiConductorMast(player.field_71071_by, this);
    }

    public int getBaseProcessTime() {
        return furnaceSpeed;
    }

    public boolean maxRender() {
        return true;
    }
}

