/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.machines.GuiDockingStation;
import sonar.calculator.mod.common.containers.ContainerDockingStation;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RecipeHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.utils.IGuiTile;

public class TileEntityDockingStation
extends TileEntityAbstractProcess
implements IGuiTile,
IAdditionalInventory {
    public ItemStack calcStack;

    public TileEntityDockingStation() {
        super(4, 1, 200, 10);
    }

    @Override
    public int inputSize() {
        return 4;
    }

    @Override
    public int outputSize() {
        return 1;
    }

    @Override
    public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
        return this.recipeHelper().getOutput(stacks);
    }

    @Override
    public RecipeHelper recipeHelper() {
        if (this.calcStack != null) {
            if (this.calcStack.func_77973_b() == Calculator.itemCalculator) {
                return RecipeRegistry.CalculatorRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Calculator.itemScientificCalculator) {
                return RecipeRegistry.ScientificRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Item.func_150898_a((Block)Calculator.atomicCalculator)) {
                return RecipeRegistry.AtomicRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Calculator.itemFlawlessCalculator) {
                return RecipeRegistry.FlawlessRecipes.instance();
            }
        }
        return RecipeRegistry.CalculatorRecipes.instance();
    }

    @Override
    public int getProcessTime() {
        return Math.max(1, super.getProcessTime() / 8);
    }

    @Override
    public int requiredEnergy() {
        return 10;
    }

    @Override
    public ItemStack[] inputStacks() {
        int size = TileEntityDockingStation.isCalculator(this.calcStack);
        if (size == 0) {
            return null;
        }
        ItemStack[] input = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            input[i] = this.slots()[i];
        }
        return input;
    }

    @Override
    public void finishProcess() {
        ItemStack[] output = this.getOutput(false, this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            if (output[o] == null) continue;
            if (this.slots()[o + this.inputSize() + 1] == null) {
                ItemStack outputStack = output[o].func_77946_l();
                if (output[o].func_77973_b() == Calculator.circuitBoard) {
                    CircuitBoard.setData(outputStack);
                }
                this.slots()[o + this.inputSize() + 1] = outputStack;
                continue;
            }
            if (!this.slots()[o + this.inputSize() + 1].func_77969_a(output[o])) continue;
            this.slots()[o + this.inputSize() + 1].field_77994_a += output[o].field_77994_a;
        }
        int i = 0;
        while (true) {
            if (i >= TileEntityDockingStation.isCalculator(this.calcStack)) break;
            this.slots()[i].field_77994_a = this.recipeHelper() != null ? (this.slots()[i].field_77994_a -= this.recipeHelper().getInputSize(i, output)) : --this.slots()[i].field_77994_a;
            if (this.slots()[i].field_77994_a <= 0) {
                this.slots()[i] = null;
            }
            ++i;
        }
    }

    public static int isCalculator(ItemStack itemstack1) {
        if (itemstack1 != null) {
            if (itemstack1.func_77973_b() == Calculator.itemCalculator) {
                return 2;
            }
            if (itemstack1.func_77973_b() == Calculator.itemScientificCalculator) {
                return 2;
            }
            if (itemstack1.func_77973_b() == Item.func_150898_a((Block)Calculator.atomicCalculator)) {
                return 3;
            }
            if (itemstack1.func_77973_b() == Calculator.itemFlawlessCalculator) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.calcStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("calcStack"));
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && this.calcStack != null) {
            NBTTagCompound stack = new NBTTagCompound();
            this.calcStack.func_77955_b(stack);
            nbt.func_74782_a("calcStack", (NBTBase)stack);
        }
        return nbt;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots()[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] outputSlot = new int[]{5};
        int[] emptySlot = new int[]{};
        int size = TileEntityDockingStation.isCalculator(this.calcStack);
        EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
        if (dir == null || size == 0) {
            return emptySlot;
        }
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return outputSlot;
        }
        if (size != 1) {
            if (side == SonarHelper.getHorizontal((EnumFacing)dir)) {
                return new int[]{0};
            }
            if (side == SonarHelper.getHorizontal((EnumFacing)dir).func_176734_d()) {
                return new int[]{1};
            }
            if ((size == 4 || size == 3) && side == SonarHelper.getHorizontal((EnumFacing)dir).func_176734_d()) {
                return new int[]{2};
            }
            if (size == 4 && side == SonarHelper.getHorizontal((EnumFacing)dir).func_176734_d()) {
                return new int[]{3};
            }
        }
        return outputSlot;
    }

    public int convertMeta(int meta) {
        EnumFacing dir = EnumFacing.func_82600_a((int)meta);
        SonarHelper.getHorizontal((EnumFacing)dir);
        if (meta <= 1) {
            meta = 5;
        } else if ((meta & 5) <= 1) {
            meta = 2;
        }
        return meta;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerDockingStation(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiDockingStation(player.field_71071_by, this);
    }

    @Override
    public ItemStack[] getAdditionalStacks() {
        if (this.calcStack != null) {
            return new ItemStack[]{this.calcStack};
        }
        return new ItemStack[0];
    }
}

