/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthProcessor;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.client.gui.machines.GuiHealthProcessor;
import sonar.calculator.mod.common.containers.ContainerHealthProcessor;
import sonar.calculator.mod.common.recipes.machines.HealthProcessorRecipes;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IGuiTile;

public class TileEntityHealthProcessor
extends TileEntitySidedInventory
implements IHealthProcessor,
IGuiTile {
    public SyncTagType.INT storedpoints = new SyncTagType.INT(0);
    public final int speed = 4;

    public TileEntityHealthProcessor() {
        this.input = new int[]{0};
        this.output = new int[]{1};
        this.inv = new SonarInventory((TileEntity)this, 2);
        this.syncParts.addAll(Arrays.asList(this.storedpoints));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.loot(this.slots()[0]);
        }
        this.charge(this.slots()[1]);
        this.func_70296_d();
    }

    public void charge(ItemStack stack) {
        int max;
        IHealthStore module;
        int health;
        if (stack != null && (Integer)this.storedpoints.getObject() != 0 && stack.func_77973_b() instanceof IHealthStore && ((health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) < (max = module.getMaxHealthPoints(stack)) || max == -1)) {
            if ((Integer)this.storedpoints.getObject() >= 4) {
                if (max == -1 || max >= health + 4) {
                    module.transferHealth(4, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-4);
                } else if (max != -1) {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - health));
                }
            } else if ((Integer)this.storedpoints.getObject() <= 4) {
                if (max == -1 | max >= health + 4) {
                    module.transferHealth(4, stack, ProcessType.ADD);
                    this.storedpoints.setObject((Object)0);
                } else if (max != -1) {
                    module.transferHealth(max - health, stack, ProcessType.ADD);
                    this.storedpoints.increaseBy(-(max - health));
                }
            }
        }
    }

    @Override
    public int getHealthPoints() {
        return (Integer)this.storedpoints.getObject();
    }

    private void loot(ItemStack stack) {
        if (stack != null) {
            IHealthStore module;
            int health;
            if (this.isLoot(stack)) {
                int add = HealthProcessorRecipes.instance().getOutput(stack);
                this.storedpoints.increaseBy(add);
                --this.slots()[0].field_77994_a;
                if (this.slots()[0].field_77994_a <= 0) {
                    this.slots()[0] = null;
                }
            }
            if (stack.func_77973_b() instanceof IHealthStore && (health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) != 0) {
                if (health >= 4) {
                    module.transferHealth(4, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(4);
                }
                if (health <= 4) {
                    module.transferHealth(health, stack, ProcessType.REMOVE);
                    this.storedpoints.increaseBy(health);
                }
            }
        }
    }

    private boolean isLoot(ItemStack stack) {
        return HealthProcessorRecipes.instance().getOutput(stack) > 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing slots) {
        if (slot == 1) {
            if ((Integer)this.storedpoints.getObject() == 0) {
                return true;
            }
            if ((Integer)this.storedpoints.getObject() != 0) {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        currenttip.add(FontHelper.translate((String)"points.health") + ": " + this.storedpoints);
        return currenttip;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerHealthProcessor(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiHealthProcessor(player.field_71071_by, this);
    }
}

