/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.misc.GuiCO2Generator;
import sonar.calculator.mod.common.containers.ContainerCO2Generator;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFlawlessGreenhouse;
import sonar.core.api.energy.EnergyMode;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.utils.IGuiTile;

public class TileEntityCO2Generator
extends TileEntityEnergyInventory
implements ISidedInventory,
IGuiTile {
    public int burnTime;
    public int maxBurnTime;
    public int maxBurn = 10000;
    public int energyAmount = 100000;
    public int gasAdd;
    public boolean controlled;
    public boolean control;
    private static final int[] input = new int[]{0};
    public EnumFacing forward = EnumFacing.NORTH;
    public EnumFacing horizontal = EnumFacing.EAST;

    public TileEntityCO2Generator() {
        this.storage.setCapacity(1000000).setMaxTransfer(64000);
        this.inv = new SonarInventory((TileEntity)this, 2);
        this.energyMode = EnergyMode.RECIEVE;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.forward = EnumFacing.func_82600_a((int)this.func_145832_p()).func_176734_d();
        this.horizontal = SonarHelper.getHorizontal((EnumFacing)this.forward);
        if (SonarHelper.getHorizontal((EnumFacing)this.forward) != null) {
            boolean flag1 = this.burnTime > 0;
            boolean flag2 = false;
            EnumFacing hoz = SonarHelper.getHorizontal((EnumFacing)this.forward).func_176734_d();
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(hoz.func_82601_c() * 3, 0, hoz.func_82599_e() * 3));
            if (this.maxBurnTime == 0 && !this.field_145850_b.field_72995_K && this.slots()[0] != null && TileEntityFurnace.func_145954_b((ItemStack)this.slots()[0]) && this.storage.getEnergyStored() >= this.energyAmount && tile != null && tile instanceof TileEntityFlawlessGreenhouse) {
                this.burn();
                this.storage.modifyEnergyStored(-this.energyAmount);
            }
            if (!this.controlled && this.maxBurnTime != 0 && this.burnTime >= 0 && this.burnTime < this.maxBurnTime) {
                flag2 = true;
                ++this.burnTime;
            }
            if (this.controlled && tile != null && tile instanceof TileEntityFlawlessGreenhouse) {
                TileEntityFlawlessGreenhouse greenhouse = (TileEntityFlawlessGreenhouse)tile;
                int carbon = greenhouse.getCarbon();
                if (this.control) {
                    if (carbon != greenhouse.maxLevel) {
                        if (this.maxBurnTime != 0 && this.burnTime >= 0 && this.burnTime < this.maxBurnTime) {
                            flag2 = true;
                            ++this.burnTime;
                            this.gasAdd = 800;
                        }
                    } else {
                        this.control = false;
                    }
                }
                if (!this.control) {
                    if (carbon <= 92000) {
                        this.control = true;
                    } else {
                        this.gasAdd = 0;
                    }
                }
            }
            if (this.burnTime == this.maxBurnTime) {
                this.maxBurnTime = 0;
                this.burnTime = 0;
                this.gasAdd = 0;
                flag2 = true;
            }
            if (flag2) {
                this.func_70296_d();
            }
        }
        this.discharge(1);
    }

    public void burn() {
        this.maxBurnTime = this.maxBurn;
        this.gasAdd = TileEntityFurnace.func_145952_a((ItemStack)this.slots()[0]) / 100;
        this.controlled = this.slots()[0].func_77973_b() == Calculator.controlled_Fuel;
        --this.slots()[0].field_77994_a;
        if (this.slots()[0].field_77994_a <= 0) {
            this.slots()[0] = null;
        }
    }

    public boolean isBurning() {
        return this.maxBurnTime != 0;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.burnTime = nbt.func_74762_e("burnTime");
            this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
            this.controlled = nbt.func_74767_n("controlled");
            this.control = nbt.func_74767_n("control");
            this.gasAdd = nbt.func_74762_e("gasAdd");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            nbt.func_74768_a("burnTime", this.burnTime);
            nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
            nbt.func_74757_a("controlled", this.controlled);
            nbt.func_74757_a("control", this.control);
            nbt.func_74768_a("gasAdd", this.gasAdd);
        }
        return nbt;
    }

    public int[] func_180463_a(EnumFacing side) {
        return input;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        if (this.burnTime > 0 && this.maxBurn != 0 && this.gasAdd == 0) {
            String burn = FontHelper.translate((String)"co2.control");
            currenttip.add(burn);
        } else if (this.burnTime > 0 && this.maxBurn != 0) {
            String burn = FontHelper.translate((String)"co2.burnt") + ": " + this.burnTime * 100 / this.maxBurn;
            currenttip.add(burn);
        } else {
            String burn = FontHelper.translate((String)"co2.burning");
            currenttip.add(burn);
        }
        return currenttip;
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerCO2Generator(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiCO2Generator(player.field_71071_by, this);
    }
}

