/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sonar.calculator.mod.client.gui.calculators.GuiAtomicCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiDynamicCalculator;
import sonar.calculator.mod.common.containers.ContainerAtomicCalculator;
import sonar.calculator.mod.common.containers.ContainerDynamicCalculator;
import sonar.core.api.blocks.IStableBlock;
import sonar.core.api.blocks.IStableGlass;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.inventory.SonarInventory;
import sonar.core.utils.FailedCoords;
import sonar.core.utils.IGuiTile;

public abstract class TileEntityCalculator
extends TileEntityInventory
implements ISidedInventory,
IGuiTile {
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public static class Atomic
    extends TileEntityCalculator {
        public Atomic() {
            this.inv = new SonarInventory((TileEntity)this, 4);
        }

        public Object getGuiContainer(EntityPlayer player) {
            return new ContainerAtomicCalculator(player, this);
        }

        public Object getGuiScreen(EntityPlayer player) {
            return new GuiAtomicCalculator(player, this);
        }
    }

    public static class Dynamic
    extends TileEntityCalculator {
        public Dynamic() {
            this.inv = new SonarInventory((TileEntity)this, 10);
        }

        public FailedCoords checkStructure() {
            EnumFacing forward = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SonarBlock.FACING)).func_176734_d();
            BlockPos centre = this.field_174879_c.func_177982_a(forward.func_82601_c() * 3, 0, forward.func_82599_e() * 3);
            FailedCoords bottom = this.outsideLayer(centre.func_177967_a(EnumFacing.DOWN, 3));
            if (!bottom.getBoolean()) {
                return bottom;
            }
            FailedCoords top = this.outsideLayer(centre.func_177967_a(EnumFacing.UP, 3));
            if (!top.getBoolean()) {
                return top;
            }
            FailedCoords middle = this.insideLayers(centre);
            if (!middle.getBoolean()) {
                return middle;
            }
            return new FailedCoords(true, BlockCoords.EMPTY, null);
        }

        public FailedCoords outsideLayer(BlockPos pos) {
            for (int X = -3; X <= 3; ++X) {
                for (int Z = -3; Z <= 3; ++Z) {
                    BlockPos current = pos.func_177982_a(X, 0, Z);
                    if (X == 3 || Z == 3 || X == -3 || Z == -3) {
                        if (this.field_145850_b.func_180495_p(current).func_177230_c() instanceof IStableBlock) continue;
                        return new FailedCoords(false, new BlockCoords(current, this.field_145850_b.field_73011_w.getDimension()), "stable");
                    }
                    if (this.field_145850_b.func_180495_p(current).func_177230_c() instanceof IStableGlass) continue;
                    return new FailedCoords(false, new BlockCoords(current, this.field_145850_b.field_73011_w.getDimension()), "glass");
                }
            }
            return new FailedCoords(true, BlockCoords.EMPTY, null);
        }

        public FailedCoords insideLayers(BlockPos pos) {
            for (int Y = -2; Y <= 2; ++Y) {
                for (int X = -3; X <= 3; ++X) {
                    for (int Z = -3; Z <= 3; ++Z) {
                        BlockPos current = pos.func_177982_a(X, Y, Z);
                        if (X == 3 || Z == 3 || X == -3 || Z == -3) {
                            if (this.field_174879_c.equals((Object)current)) continue;
                            if (X == 3 && Z == 3 || X == -3 && Z == -3 || X == -3 && Z == 3 || X == 3 && Z == -3) {
                                if (this.field_145850_b.func_180495_p(current).func_177230_c() instanceof IStableBlock) continue;
                                return new FailedCoords(false, new BlockCoords(current, this.field_145850_b.field_73011_w.getDimension()), "stable");
                            }
                            if (this.field_145850_b.func_180495_p(current).func_177230_c() instanceof IStableGlass) continue;
                            return new FailedCoords(false, new BlockCoords(current, this.field_145850_b.field_73011_w.getDimension()), "glass");
                        }
                        if (this.field_145850_b.func_180495_p(current).func_177230_c() == Blocks.field_150350_a) continue;
                        return new FailedCoords(false, new BlockCoords(current, this.field_145850_b.field_73011_w.getDimension()), "air");
                    }
                }
            }
            return new FailedCoords(true, BlockCoords.EMPTY, null);
        }

        public Object getGuiContainer(EntityPlayer player) {
            return new ContainerDynamicCalculator(player, this);
        }

        public Object getGuiScreen(EntityPlayer player) {
            return new GuiDynamicCalculator(player, this);
        }
    }
}

