/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.client.gui.misc.GuiMagneticFlux;
import sonar.calculator.mod.common.containers.ContainerMagneticFlux;
import sonar.core.api.SonarAPI;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.IGuiTile;

public class TileEntityMagneticFlux
extends TileEntityInventory
implements ISidedInventory,
IByteBufTile,
IGuiTile {
    public boolean whitelisted;
    public boolean exact;
    public Random rand = new Random();
    public float rotate = 0.0f;
    public boolean disabled;

    public TileEntityMagneticFlux() {
        this.inv = new SonarInventory((TileEntity)this, 8);
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            this.disabled = true;
            return;
        }
        this.disabled = false;
        if (this.field_145850_b.field_72995_K) {
            this.rotate = !(this.rotate >= 1.0f) ? (this.rotate += 0.01f) : 0.0f;
        }
        this.magnetizeItems();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            this.whitelisted = nbt.func_74767_n("blacklisted");
            this.exact = nbt.func_74767_n("exact");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE})) {
            nbt.func_74757_a("blacklisted", this.whitelisted);
            nbt.func_74757_a("exact", this.exact);
        }
        return nbt;
    }

    public void magnetizeItems() {
        int range = 10;
        AxisAlignedBB aabb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range), (double)(this.field_174879_c.func_177956_o() - range), (double)(this.field_174879_c.func_177952_p() - range), (double)(this.field_174879_c.func_177958_n() + range), (double)(this.field_174879_c.func_177956_o() + range), (double)(this.field_174879_c.func_177952_p() + range));
        List items = this.field_145850_b.func_175647_a(EntityItem.class, aabb, null);
        for (EntityItem entity : items) {
            double z;
            double y;
            if (!this.validItemStack(entity.func_92059_d())) continue;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.2 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.5) {
                ItemStack itemstack = this.addToInventory(entity);
                if (itemstack == null || itemstack.field_77994_a <= 0) {
                    entity.func_70106_y();
                    continue;
                }
                entity.func_92058_a(itemstack);
                continue;
            }
            double speed = entity.func_70027_ad() ? 5.2 : 0.1;
            entity.field_70159_w += x / distance * speed;
            entity.field_70181_x += y * speed;
            if (y > 0.0) {
                entity.field_70181_x = 0.1;
            }
            entity.field_70179_y += z / distance * speed;
        }
    }

    public boolean validItemStack(ItemStack stack) {
        if (this.slots() == null) {
            return true;
        }
        for (int i = 0; i < this.slots().length; ++i) {
            if (this.slots()[i] == null) continue;
            boolean matches = this.matchingStack(this.slots()[i], stack);
            if (!this.whitelisted && matches) {
                return false;
            }
            if (!this.whitelisted || !matches) continue;
            return true;
        }
        return !this.whitelisted;
    }

    public boolean matchingStack(ItemStack stack, ItemStack stack2) {
        if (this.exact) {
            int[] stackDict = OreDictionary.getOreIDs((ItemStack)stack2);
            int[] storedDict = OreDictionary.getOreIDs((ItemStack)stack);
            for (int i = 0; i < stackDict.length; ++i) {
                for (int s = 0; s < storedDict.length; ++s) {
                    if (stackDict[i] != storedDict[s]) continue;
                    return true;
                }
            }
        }
        return !(stack.func_77973_b() != stack2.func_77973_b() || !this.exact && stack.func_77952_i() != stack2.func_77952_i() || !this.exact && !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack2));
    }

    public ItemStack addToInventory(EntityItem item) {
        if (!this.field_145850_b.field_72995_K) {
            EntityItem entity = (EntityItem)this.field_145850_b.func_73045_a(item.func_145782_y());
            if (entity == null) {
                return null;
            }
            ItemStack itemstack = entity.func_92059_d();
            if (itemstack != null) {
                int i = itemstack.field_77994_a;
                TileEntity target = SonarHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)EnumFacing.DOWN);
                if (target != null) {
                    itemstack = SonarAPI.getItemHelper().getStackToAdd((long)itemstack.field_77994_a, new StoredItemStack(itemstack), SonarAPI.getItemHelper().addItems(target, new StoredItemStack(itemstack), EnumFacing.func_82600_a((int)1), ActionType.PERFORM, null)).getFullStack();
                }
            }
            return itemstack;
        }
        return item.func_92059_d();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        if (!this.disabled) {
            String active = FontHelper.translate((String)"locator.state") + " : " + FontHelper.translate((String)"state.on");
            currenttip.add(active);
        } else {
            String idle = FontHelper.translate((String)"locator.state") + " : " + FontHelper.translate((String)"state.off");
            currenttip.add(idle);
        }
        return currenttip;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.whitelisted = !this.whitelisted;
                buf.writeBoolean(this.whitelisted);
                break;
            }
            case 1: {
                this.exact = !this.exact;
                buf.writeBoolean(this.exact);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.whitelisted = buf.readBoolean();
                break;
            }
            case 1: {
                this.exact = buf.readBoolean();
            }
        }
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerMagneticFlux(player.field_71071_by, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiMagneticFlux(player.field_71071_by, this);
    }
}

