/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.calculator.mod.common.tileentity.misc.TileEntityCalculatorScreen;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketCalculatorScreen
extends PacketCoords {
    public int type;
    public long energy;

    public PacketCalculatorScreen() {
    }

    public PacketCalculatorScreen(BlockPos pos, int type, long energy) {
        super(pos);
        this.type = type;
        this.energy = energy;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = buf.readInt();
        this.energy = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.type);
        buf.writeLong(this.energy);
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketCalculatorScreen> {
        public IMessage processMessage(PacketCalculatorScreen message, TileEntity target) {
            if (target instanceof TileEntityCalculatorScreen) {
                TileEntityCalculatorScreen screen = (TileEntityCalculatorScreen)target;
                if (message.type == 0) {
                    screen.latestMax = message.energy;
                } else {
                    screen.latestEnergy = message.energy;
                }
            }
            return null;
        }
    }
}

