/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.research;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.research.IResearch;
import sonar.calculator.mod.research.types.ResearchTypes;
import sonar.core.helpers.NBTHelper;

public class PlayerResearchRegistry {
    private static LinkedHashMap<String, ArrayList<IResearch>> research = new LinkedHashMap();

    public static void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList research = new NBTTagList();
        for (Map.Entry<String, ArrayList<IResearch>> entry : PlayerResearchRegistry.research.entrySet()) {
            NBTTagCompound playerTag = new NBTTagCompound();
            playerTag.func_74778_a("player", entry.getKey());
            PlayerResearchRegistry.writePlayerData(entry.getValue(), playerTag, type);
            research.func_74742_a((NBTBase)playerTag);
        }
        if (!research.func_82582_d()) {
            nbt.func_74782_a("research", (NBTBase)research);
        }
    }

    public static void writePlayerData(EntityPlayer player, NBTTagCompound nbt, NBTHelper.SyncType type) {
        ArrayList<IResearch> playerResearch = new ArrayList<IResearch>();
        if (research.get(player.func_70005_c_()) != null) {
            playerResearch = research.get(player.func_70005_c_());
        }
        PlayerResearchRegistry.writePlayerData(playerResearch, nbt, type);
    }

    public static void writePlayerData(ArrayList<IResearch> research, NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList researchList = new NBTTagList();
        for (IResearch r : research) {
            NBTTagCompound researchTag = new NBTTagCompound();
            researchTag.func_74778_a("researchType", r.getName());
            r.writeData(researchTag, type);
            if (researchTag.func_82582_d()) continue;
            researchList.func_74742_a((NBTBase)researchTag);
        }
        if (!researchList.func_82582_d()) {
            nbt.func_74782_a("researchList", (NBTBase)researchList);
        }
    }

    public static void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList research = nbt.func_150295_c("research", 10);
        for (int i = 0; i < research.func_74745_c(); ++i) {
            NBTTagCompound playerTag = research.func_150305_b(i);
            if (playerTag == null) continue;
            PlayerResearchRegistry.research.put(playerTag.func_74779_i("player"), PlayerResearchRegistry.readPlayerData(playerTag, type));
        }
    }

    public static ArrayList<IResearch> readPlayerData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        ArrayList<IResearch> playerResearch = new ArrayList<IResearch>();
        if (nbt.func_74764_b("researchList")) {
            NBTTagList researchList = nbt.func_150295_c("researchList", 10);
            for (int j = 0; j < researchList.func_74745_c(); ++j) {
                NBTTagCompound researchTag = researchList.func_150305_b(j);
                String researchType = researchTag.func_74779_i("researchType");
                IResearch rtype = (IResearch)Calculator.research.getRegisteredObject(researchType);
                if (rtype == null) continue;
                IResearch toAdd = rtype.getInstance();
                toAdd.readData(researchTag, type);
                playerResearch.add(toAdd);
            }
        }
        return playerResearch;
    }

    public static IResearch getSpecificResearch(String player, ResearchTypes researchType) {
        ArrayList<IResearch> playerResearch = PlayerResearchRegistry.getPlayerResearch(player);
        for (IResearch research : playerResearch) {
            if (!research.getName().equals(researchType.name())) continue;
            return research;
        }
        IResearch type = (IResearch)Calculator.research.getRegisteredObject(researchType.name());
        if (type != null) {
            research.get(player).add(type.getInstance());
            return PlayerResearchRegistry.getSpecificResearch(player, researchType);
        }
        return null;
    }

    public static ArrayList<IResearch> getPlayerResearch(String name) {
        if (name != null) {
            if (research.get(name) == null) {
                research.put(name, new ArrayList());
            }
            return research.get(name);
        }
        return new ArrayList<IResearch>();
    }
}

