/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.utils;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.calculator.mod.api.machines.ITeleport;
import sonar.calculator.mod.api.machines.TeleportLink;
import sonar.calculator.mod.common.tileentity.misc.TileEntityTeleporter;

public class TeleporterRegistry {
    private static Map<Integer, ITeleport> teleporters = new THashMap();

    public static void removeAll() {
        teleporters.clear();
    }

    public static List<ITeleport> getTeleporters() {
        ArrayList<ITeleport> list = new ArrayList<ITeleport>();
        for (Map.Entry<Integer, ITeleport> teleport : teleporters.entrySet()) {
            list.add(teleport.getValue());
        }
        return list;
    }

    public static void removeTeleporter(ITeleport teleport) {
        teleporters.remove(teleport);
    }

    public static void addTeleporter(ITeleport teleport) {
        teleporters.put(teleport.teleporterID(), teleport);
    }

    public static int nextID() {
        int nextID = 0;
        boolean flag = false;
        while (!flag) {
            if (teleporters.get(++nextID) != null) continue;
            flag = true;
        }
        return nextID;
    }

    public static TileEntityTeleporter getTile(ITeleport teleport) {
        if (teleport == null) {
            return null;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.func_71218_a(teleport.teleporterID());
        if (world != null) {
            TileEntity target = world.func_175625_s(teleport.getCoords().getBlockPos());
            return (TileEntityTeleporter)(target instanceof TileEntityTeleporter ? target : null);
        }
        return null;
    }

    public static ITeleport getPoint(ITeleport flux) {
        TileEntityTeleporter target = TeleporterRegistry.getTile(flux);
        return target;
    }

    public static List<TeleportLink> getTeleportLinks(int currentID) {
        List<ITeleport> teleports = TeleporterRegistry.getTeleporters();
        ArrayList<TeleportLink> list = new ArrayList<TeleportLink>();
        for (ITeleport teleport : teleports) {
            if (teleport == null || teleport.teleporterID() == currentID) continue;
            TileEntityTeleporter tile = TeleporterRegistry.getTile(teleport);
            if (tile != null) {
                list.add(new TeleportLink(teleport.teleporterID(), teleport.name(), teleport.getCoords().getDimension()));
                continue;
            }
            teleporters.remove(teleport.teleporterID());
        }
        Collections.sort(list, new Comparator<TeleportLink>(){

            @Override
            public int compare(TeleportLink str1, TeleportLink str2) {
                int res = String.CASE_INSENSITIVE_ORDER.compare(str1.networkName, str2.networkName);
                if (res == 0) {
                    res = str1.networkName.compareTo(str2.networkName);
                }
                return res;
            }
        });
        return list;
    }
}

