/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage;

import com.google.common.collect.Lists;
import com.tattyseal.compactstorage.exception.InvalidConfigurationException;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static File configFile;
    public static boolean firstTimeRun;
    public static ItemStack storage;
    public static ItemStack storageBackpack;
    public static ItemStack[] primary;
    public static ItemStack[] secondary;
    public static ItemStack binder;
    public static ItemStack binderBackpack;
    public static float storageModifier;
    public static float primaryModifier;
    public static float secondaryModifier;
    public static float binderModifier;
    public static boolean shouldConnect;

    public static void init() {
        configuration = new Configuration(configFile);
        firstTimeRun = configuration.getBoolean("firstTimeRun", "internal", false, "This is used internally for the GUI shown when you first start the game.");
        storage = ConfigurationHandler.getItemFromConfig(configuration, "chestStorage", "builder", "minecraft:chest", "This is used as the first component in the Builder when building a CHEST.");
        storageBackpack = ConfigurationHandler.getItemFromConfig(configuration, "backpackStorage", "builder", "minecraft:wool", "This is used as the first component in the Builder when building a BACKPACK.");
        primary = ConfigurationHandler.getItemsFromConfig(configuration, "primaryItem", "builder", new String[]{"minecraft:iron_ingot"}, "These values are used for the first material cost in the chest builder, you can add as many values as you like, it will configure itself to use all of them.");
        secondary = ConfigurationHandler.getItemsFromConfig(configuration, "secondaryItem", "builder", new String[]{"minecraft:iron_bars"}, "These values are used for the second material cost in the chest builder, you can add as many values as you like, it will configure itself to use all of them.");
        binder = ConfigurationHandler.getItemFromConfig(configuration, "chestBinder", "builder", "minecraft:clay_ball", "This is used as the binder material when making a CHEST.");
        binderBackpack = ConfigurationHandler.getItemFromConfig(configuration, "backpackBinder", "builder", "minecraft:string", "This is used as the binder material when making a BACKPACK.");
        storageModifier = configuration.getFloat("storageModifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        primaryModifier = configuration.getFloat("primaryModifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        secondaryModifier = configuration.getFloat("secondaryModifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        binderModifier = configuration.getFloat("binderModifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        configuration.setCategoryComment("builder", "Format for item names is modid:name@meta or leave @meta for all possible metadata of that item. These are not unlocalized names. If you do something wrong or it uses the defaut values check your log!!! Look for an InvalidConfigurationException and it will tell you why!");
        if (firstTimeRun) {
            configuration.get("internal", "firstTimeRun", false).set(false);
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
        shouldConnect = configuration.getBoolean("shouldConnectToNetworks", "chest", true, "This determines whether chests will connect to ES networks.");
    }

    public static ItemStack getItemFromConfig(Configuration config, String name, String category, String defaultString, String comment) {
        int meta;
        String itemId;
        String itemName = config.getString(name, category, defaultString, comment);
        String modId = itemName.contains(":") ? itemName.split(":", 2)[0] : "minecraft";
        String string = itemId = itemName.contains(":") ? itemName.split(":", 2)[1] : itemName;
        if (itemName.contains("@")) {
            meta = Integer.parseInt(itemId.split("@")[1]);
            itemId = itemId.split("@")[0];
        } else {
            meta = Short.MAX_VALUE;
        }
        Item item = GameRegistry.findItem((String)modId, (String)itemId);
        if (item == null) {
            new InvalidConfigurationException("Could not find item " + itemName + " for value " + name + " in the CompactStorage config! Reverting to default.").printStackTrace();
            modId = defaultString.contains(":") ? defaultString.split(":", 2)[0] : "minecraft";
            String string2 = itemId = defaultString.contains(":") ? defaultString.split(":", 2)[1] : defaultString;
            if (itemName.contains("@")) {
                meta = Integer.parseInt(itemId.split("@")[1]);
                itemId = itemId.split("@")[0];
            } else {
                meta = Short.MAX_VALUE;
            }
            item = GameRegistry.findItem((String)modId, (String)itemId);
            return new ItemStack(item, 1, meta);
        }
        return new ItemStack(item, 1, meta);
    }

    public static ItemStack[] getItemsFromConfig(Configuration config, String key, String category, String[] defaultItems, String comment) {
        Item item;
        int meta;
        String itemId;
        String modId;
        ArrayList items = Lists.newArrayList();
        String[] itemNames = config.getStringList(key, category, defaultItems, comment);
        boolean breakOff = false;
        for (String itemName : itemNames) {
            modId = itemName.contains(":") ? itemName.split(":", 2)[0] : "minecraft";
            String string = itemId = itemName.contains(":") ? itemName.split(":", 2)[1] : itemName;
            if (itemName.contains("@")) {
                meta = Integer.parseInt(itemId.split("@")[1]);
                itemId = itemId.split("@")[0];
            } else {
                meta = Short.MAX_VALUE;
            }
            item = GameRegistry.findItem((String)modId, (String)itemId);
            if (item == null) {
                new InvalidConfigurationException("Could not find item " + itemName + " for value " + key + " in the CompactStorage config! Reverting to default.").printStackTrace();
                breakOff = true;
                break;
            }
            items.add(new ItemStack(item, 1, meta));
        }
        if (breakOff) {
            items.clear();
            for (String itemName : defaultItems) {
                modId = itemName.contains(":") ? itemName.split(":", 2)[0] : "minecraft";
                String string = itemId = itemName.contains(":") ? itemName.split(":", 2)[1] : itemName;
                if (itemName.contains("@")) {
                    meta = Integer.parseInt(itemId.split("@")[1]);
                    itemId = itemId.split("@")[0];
                } else {
                    meta = Short.MAX_VALUE;
                }
                item = GameRegistry.findItem((String)modId, (String)itemId);
                items.add(new ItemStack(item, 1, meta));
            }
        }
        return items.toArray(new ItemStack[items.size()]);
    }
}

