/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.block;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.exception.InvalidSizeException;
import com.tattyseal.compactstorage.tileentity.TileEntityChest;
import com.tattyseal.compactstorage.util.EntityUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockChest
extends Block
implements ITileEntityProvider {
    public BlockChest() {
        super(Material.field_151575_d);
        this.func_149663_c("compactchest");
        this.func_149647_a(CompactStorage.tabCS);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("axe", 1);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        chest.direction = EntityUtil.get2dOrientation(entity);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            if (stack.func_77978_p().func_74781_a("size") instanceof NBTTagIntArray) {
                String color;
                chest.invX = stack.func_77978_p().func_74759_k("size")[0];
                chest.invY = stack.func_77978_p().func_74759_k("size")[1];
                chest.color = stack.func_77978_p().func_74764_b("color") ? ((color = stack.func_77978_p().func_74779_i("color")) == "" ? 0xFFFFFF : Integer.decode(color)) : 0xFFFFFF;
                chest.items = new ItemStack[chest.invX * chest.invY];
            } else if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You attempted something bad! :("));
                chest.invX = 9;
                chest.invY = 3;
                chest.items = new ItemStack[chest.invX * chest.invY];
                chest.color = 0xFFFFFF;
                InvalidSizeException exception = new InvalidSizeException("You tried to pass off a " + stack.func_77978_p().func_74781_a("size").getClass().getName() + " as a Integer Array. Do not report this or you will be ignored. This is a user based error.");
                exception.printStackTrace();
            }
        } else if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You attempted something bad! :("));
            chest.invX = 9;
            chest.invY = 3;
            chest.items = new ItemStack[chest.invX * chest.invY];
            chest.color = 0xFFFFFF;
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing facing, float x, float y, float z) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            player.openGui((Object)CompactStorage.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return !player.func_70093_af();
    }

    public TileEntity func_149915_a(World world, int dim) {
        return new TileEntityChest();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        if (chest != null) {
            ItemStack stack = new ItemStack(CompactStorage.chest, 1);
            Random rand = new Random();
            stack.func_77982_d(new NBTTagCompound());
            int invX = chest.invX;
            int invY = chest.invY;
            int color = chest.color;
            stack.func_77978_p().func_74783_a("size", new int[]{invX, invY});
            stack.func_77978_p().func_74768_a("color", color);
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
            for (int slot = 0; slot < chest.items.length; ++slot) {
                float randX = rand.nextFloat();
                float randZ = rand.nextFloat();
                if (chest.items == null || chest.items[slot] == null) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + randX), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + randZ), chest.items[slot]));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 4));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(CompactStorage.chest, 1);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74783_a("size", new int[]{chest.invX, chest.invY});
        return stack;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

