/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.inventory;

import com.tattyseal.compactstorage.api.IChest;
import com.tattyseal.compactstorage.util.StorageInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class InventoryBackpack
implements IChest {
    public ItemStack stack;
    public int[] size;
    public ItemStack[] items;

    public InventoryBackpack(ItemStack stack) {
        this.stack = stack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            this.size = stack.func_77978_p().func_74759_k("size");
        } else {
            this.size = new int[]{9, 3};
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74783_a("size", new int[]{9, 3});
        }
        this.items = new ItemStack[this.func_70302_i_()];
        this.readFromNBT(this.stack.func_77978_p());
    }

    @Override
    public int getInvX() {
        return this.size[0];
    }

    @Override
    public int getInvY() {
        return this.size[1];
    }

    @Override
    public StorageInfo getInfo() {
        return new StorageInfo(this.getInvX(), this.getInvY());
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    public int func_70302_i_() {
        return this.getInvX() * this.getInvY() + 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < this.items.length && this.items[slot] != null) {
            return this.items[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
                this.func_70296_d();
                return stack.func_77946_l();
            }
            ItemStack stack2 = stack.func_77979_a(amount);
            this.func_70296_d();
            return stack2.func_77946_l();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.items != null) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return "backpack.inv";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeToNBT(this.stack.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.writeToNBT(this.stack.func_77978_p());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList nbtTagList = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int slot = 0; slot < nbtTagList.func_74745_c(); ++slot) {
            NBTTagCompound item = nbtTagList.func_150305_b(slot);
            int i = item.func_74762_e("Slot");
            if (i < 0 || i >= this.func_70302_i_()) continue;
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (slot >= this.items.length || this.items[slot] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", slot);
            this.items[slot].func_77955_b(item);
            nbtTagList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)nbtTagList);
    }

    @Override
    public boolean shouldConnectToNetwork() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

