/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.network.handler;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.network.packet.C02PacketCraftChest;
import com.tattyseal.compactstorage.tileentity.TileEntityChestBuilder;
import com.tattyseal.compactstorage.util.LogHelper;
import com.tattyseal.compactstorage.util.StorageInfo;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.oredict.OreDictionary;

public class C02HandlerCraftChest
implements IMessageHandler<C02PacketCraftChest, IMessage> {
    public IMessage onMessage(C02PacketCraftChest message, MessageContext ctx) {
        TileEntityChestBuilder builder = (TileEntityChestBuilder)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension).func_175625_s(new BlockPos(message.x, message.y, message.z));
        List<ItemStack> items = Arrays.asList(builder.items);
        List<ItemStack> requiredItems = builder.info.getMaterialCost(message.type);
        boolean hasRequiredMaterials = true;
        for (int slot = 0; slot < items.size(); ++slot) {
            ItemStack stack = items.get(slot);
            if (stack != null && slot < requiredItems.size() && requiredItems.get(slot) != null) {
                if (!OreDictionary.itemMatches((ItemStack)requiredItems.get(slot), (ItemStack)stack, (boolean)false) || stack.field_77994_a < requiredItems.get((int)slot).field_77994_a) {
                    if (requiredItems.get(slot) != null && requiredItems.get((int)slot).field_77994_a == 0) {
                        hasRequiredMaterials = true;
                        break;
                    }
                    hasRequiredMaterials = false;
                    break;
                }
            } else {
                hasRequiredMaterials = false;
                break;
            }
            hasRequiredMaterials = true;
        }
        LogHelper.dump("HAS REQ MATS: " + hasRequiredMaterials);
        if (hasRequiredMaterials) {
            ItemStack stack = new ItemStack(message.type.equals((Object)StorageInfo.Type.BACKPACK) ? CompactStorage.backpack : ItemBlock.func_150898_a((Block)CompactStorage.chest), 1);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("size", new int[]{message.info.getSizeX(), message.info.getSizeY()});
            tag.func_74778_a("color", message.color);
            stack.func_77982_d(tag);
            EntityItem item = new EntityItem(ctx.getServerHandler().field_147369_b.field_70170_p, (double)message.x, (double)(message.y + 1), (double)message.z, stack);
            ctx.getServerHandler().field_147369_b.field_70170_p.func_72838_d((Entity)item);
            LogHelper.dump("SPAWNED ITEM ENTITY");
            for (int x = 0; x < requiredItems.size(); ++x) {
                builder.func_70298_a(x, requiredItems.get((int)x).field_77994_a);
                LogHelper.dump("DECREASED ITEMS IN INVENTORY");
            }
        }
        return null;
    }
}

