/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.network.packet;

import com.tattyseal.compactstorage.util.StorageInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class C02PacketCraftChest
implements IMessage {
    public int x;
    public int y;
    public int z;
    public int dimension;
    public StorageInfo info;
    public StorageInfo.Type type;
    public String color;

    public C02PacketCraftChest() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.dimension = 0;
        this.info = new StorageInfo(0, 0);
        this.type = StorageInfo.Type.CHEST;
        this.color = "0xFFFFFF";
    }

    public C02PacketCraftChest(int x, int y, int z, int dim, StorageInfo info, StorageInfo.Type type, String color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dim;
        this.info = info;
        this.type = type;
        this.color = color;
    }

    public C02PacketCraftChest(BlockPos pos, int dim, StorageInfo info, StorageInfo.Type type, String color) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.dimension = dim;
        this.info = info;
        this.type = type;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dimension = buf.readInt();
        this.info = new StorageInfo(buf.readInt(), buf.readInt());
        this.type = StorageInfo.Type.values()[buf.readInt()];
        this.color = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dimension);
        buf.writeInt(this.info.getSizeX());
        buf.writeInt(this.info.getSizeY());
        buf.writeInt(this.type.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.color);
    }
}

