/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderUtil {
    public static final ResourceLocation slotTexture = new ResourceLocation("compactstorage", "textures/gui/chestSlots.png");
    public static final ResourceLocation backgroundTexture = new ResourceLocation("compactstorage", "textures/gui/chest.png");
    public static final ResourceLocation colorTexture = new ResourceLocation("compactstorage", "textures/gui/colorGrid.png");
    private static double slotTextureWidth = 432.0;
    private static double slotTextureHeight = 216.0;
    private static double chestTextureWidth = 15.0;
    private static double chestTextureHeight = 15.0;
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static void renderSlots(int x, int y, int width, int height) {
        RenderUtil.mc.field_71446_o.func_110577_a(slotTexture);
        int realWidth = width * 18;
        int realHeight = height * 18;
        double ux = 1.0 / slotTextureWidth * (double)realWidth;
        double uz = 1.0 / slotTextureHeight * (double)realHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + realHeight), 0.0).func_187315_a(0.0, uz).func_181675_d();
        worldRenderer.func_181662_b((double)(x + realWidth), (double)(y + realHeight), 0.0).func_187315_a(ux, uz).func_181675_d();
        worldRenderer.func_181662_b((double)(x + realWidth), (double)(y + 0), 0.0).func_187315_a(ux, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderChestBackground(GuiContainer gui, int x, int y, int width, int height) {
        RenderUtil.renderBackground(gui, x, y, Math.max(9, width) * 18, height * 18);
    }

    public static void renderBackground(GuiContainer gui, int x, int y, int width, int height) {
        RenderUtil.mc.field_71446_o.func_110577_a(backgroundTexture);
        int realWidth = 7 + width + 7;
        int realHeight = 15 + height + 13 + 54 + 4 + 18 + 7;
        int by = y + (realHeight - 7);
        RenderUtil.renderPartBackground(x, y, 0, 0, 7, 7, 7, 7);
        RenderUtil.renderPartBackground(x + 7, y, 8, 0, 8, 7, width, 7);
        RenderUtil.renderPartBackground(x + 7 + width, y, 9, 0, 15, 7, 7, 7);
        RenderUtil.renderPartBackground(x, by, 0, 8, 7, 15, 7, 7);
        RenderUtil.renderPartBackground(x + 7, by, 8, 8, 7, 15, width, 7);
        RenderUtil.renderPartBackground(x + 7 + width, by, 9, 8, 15, 15, 7, 7);
        RenderUtil.renderPartBackground(x, y + 7, 0, 7, 7, 7, 7, realHeight - 14);
        RenderUtil.renderPartBackground(x + realWidth - 8, y + 7, 8, 7, 15, 7, 8, realHeight - 14);
        RenderUtil.renderPartBackground(x + 7, y + 7, 8, 8, 8, 8, width, realHeight - 14);
    }

    private static void renderPartBackground(int x, int y, int startX, int startY, int endX, int endY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)y + (double)height, 0.0).func_187315_a(RenderUtil.getEnd(chestTextureWidth, startX), RenderUtil.getEnd(chestTextureHeight, endY)).func_181675_d();
        worldRenderer.func_181662_b((double)x + (double)width, (double)y + (double)height, 0.0).func_187315_a(RenderUtil.getEnd(chestTextureWidth, endX), RenderUtil.getEnd(chestTextureHeight, endY)).func_181675_d();
        worldRenderer.func_181662_b((double)x + (double)width, (double)y + 0.0, 0.0).func_187315_a(RenderUtil.getEnd(chestTextureWidth, endX), RenderUtil.getEnd(chestTextureHeight, startY)).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(RenderUtil.getEnd(chestTextureWidth, startX), RenderUtil.getEnd(chestTextureHeight, startY)).func_181675_d();
        tessellator.func_78381_a();
    }

    private static double getEnd(double width, double other) {
        return 1.0 / width * other;
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

