/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.util;

import com.tattyseal.compactstorage.ConfigurationHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StorageInfo {
    private int sizeX;
    private int sizeY;

    public StorageInfo(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    public List<ItemStack> getMaterialCost(Type type) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int storageAmount = (int)((float)(this.sizeX * this.sizeY) / 8.0f * ConfigurationHandler.storageModifier);
        list.add(this.changeStackSize(type.equals((Object)Type.BACKPACK) ? ConfigurationHandler.storageBackpack : ConfigurationHandler.storage, type.equals((Object)Type.BACKPACK) ? storageAmount : storageAmount / 2));
        int amount = ConfigurationHandler.primary.length;
        int maxChest = 288;
        int thisChest = this.sizeX * this.sizeY;
        int divider = maxChest / amount;
        int primaryTier = 0;
        ItemStack primaryStack = null;
        for (int i = 0; i < amount; ++i) {
            if (thisChest > divider * (i + 1)) continue;
            primaryTier = i;
            break;
        }
        primaryStack = ConfigurationHandler.primary[primaryTier];
        list.add(this.changeStackSize(primaryStack, (int)((float)(this.sizeX * this.sizeY) / 4.5f / (float)(primaryTier + 1) * ConfigurationHandler.primaryModifier)));
        amount = ConfigurationHandler.secondary.length;
        divider = maxChest / amount;
        int secondaryTier = 0;
        ItemStack secondaryStack = null;
        for (int i = 0; i < amount; ++i) {
            if (thisChest > divider * (i + 1)) continue;
            secondaryTier = i;
            break;
        }
        secondaryStack = ConfigurationHandler.secondary[secondaryTier];
        list.add(this.changeStackSize(secondaryStack, (int)((float)(this.sizeX * this.sizeY) / 4.5f / (float)(secondaryTier + 1) * ConfigurationHandler.secondaryModifier)));
        int binderAmount = (int)((float)(this.sizeX * this.sizeY) / 8.0f * ConfigurationHandler.binderModifier);
        list.add(this.changeStackSize(type.equals((Object)Type.BACKPACK) ? ConfigurationHandler.binderBackpack : ConfigurationHandler.binder, binderAmount / 2));
        return list;
    }

    public ItemStack changeStackSize(ItemStack stack, int amount) {
        if (amount <= 0) {
            amount = 1;
        }
        stack.field_77994_a = amount;
        return stack;
    }

    public static NBTTagCompound writeToNBT(StorageInfo info) {
        if (info != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("sizeX", info.getSizeX());
            tag.func_74768_a("sizeY", info.getSizeY());
            return tag;
        }
        return null;
    }

    public static StorageInfo readFromNBT(NBTTagCompound tag) {
        if (tag == null) {
            return new StorageInfo(9, 3);
        }
        StorageInfo info = new StorageInfo(tag.func_74762_e("sizeX"), tag.func_74762_e("sizeY"));
        return info;
    }

    public static enum Type {
        CHEST,
        BACKPACK;

    }
}

