/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.resource.Resource;

public final class Config
implements UniDict.IDependence {
    public final boolean keepOneEntry;
    public final boolean inputReplacement;
    public final Set<String> keepOneEntryModBlackSet;
    public final boolean autoHideInJEI;
    public final Set<String> hideInJEIBlackSet;
    public final boolean kindDebugMode;
    public final boolean enableSpecificKindSort;
    public final TObjectIntMap<String> ownerOfEveryThing;
    public final Set<String> metalsToUnify;
    public final Set<String> childrenOfMetals;
    public final List<String> resourceBlackList;
    public final Map<String, Set<String>> customUnifiedResources;
    public final List<String> userRegisteredOreDictEntries;
    public final boolean integrationModule;
    public final boolean craftingIntegration;
    public final boolean furnaceIntegration;
    public final boolean abyssalCraft;
    public final boolean ae2Integration;
    public final boolean baseMetalsIntegration;
    public final boolean calculatorIntegration;
    public final boolean bloodMagicIntegration;
    public final boolean enderIOIntegration;
    public final boolean forestryIntegration;
    public final boolean foundryIntegration;
    public final boolean ic2Integration;
    public final boolean ieIntegration;
    public final boolean mekanismIntegration;
    public final boolean modularMachinesIntegration;
    public final boolean railCraftIntegration;
    public final boolean techRebornIntegration;
    private final Configuration config;
    private final String resources = "resources";
    public final boolean forestry;
    public final boolean ic2;

    private Config() {
        boolean deleted = false;
        this.config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "UniDict" + ".cfg"), "1.10.2-2.1");
        try {
            if (!this.config.getDefinedConfigVersion().equals(this.config.getLoadedConfigVersion())) {
                deleted = this.config.getConfigFile().delete();
            }
            String general = "general";
            this.keepOneEntry = this.config.getBoolean("keepOneEntry", "general", false, "keep only one entry per ore dict entry?");
            this.inputReplacement = this.config.getBoolean("inputReplacement", "general", false, "Enabling this will remove all non-standard items as input.\nNote: this will only affect machines that doesn't use OreDictionary.");
            this.keepOneEntryModBlackSet = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(this.config.getStringList("keepOneEntryModBlackList", "general", new String[0], "mods listed here will be blacklisted in keepOneEntry.\nmust be the exact modID."))));
            this.autoHideInJEI = this.config.getBoolean("autoHideInJEI", "general", true, "auto hide items in JEI?") && Loader.isModLoaded((String)"JEI");
            this.hideInJEIBlackSet = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(this.config.getStringList("autoHideInJEIBlackList", "general", new String[]{"ore"}, "put here things that you don't want to hide in JEI.\nonly works if keepOneEntry is false."))));
            this.kindDebugMode = this.config.getBoolean("kindDebugMode", "general", false, "Enable this to keep track of all the kinds.\nthe output will be in logs folder.");
            this.enableSpecificKindSort = this.config.getBoolean("enableSpecificKindSort", "resources", false, "enabling this allow you to specify the \"owner\" of each kind.\nalso will make \"S:ownerOfEveryThing\" be ignored.");
            this.ownerOfEveryThing = new TObjectIntHashMap((TObjectIntMap)(!this.enableSpecificKindSort ? this.getOwnerOfEveryThingMap() : new TObjectIntHashMap()));
            this.metalsToUnify = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(this.config.getStringList("metalsToUnify", "resources", new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Lead", "Nickel", "Platinum", "Zinc", "Aluminium", "Aluminum", "Alumina", "Chromium", "Chrome", "Uranium", "Iridium", "Osmium", "Bronze", "Steel", "Brass", "Invar", "Electrum", "Cupronickel", "Constantan"}, "list of things to do unifying things.\n"))));
            this.childrenOfMetals = Collections.unmodifiableSet(Sets.newLinkedHashSet(Arrays.asList(this.config.getStringList("childrenOfMetals", "resources", new String[]{"ore", "dustTiny", "dustSmall", "chunk", "dust", "nugget", "ingot", "block", "plate", "gear", "rod"}, "what kind of child do you want to make a standard?\n"))));
            this.resourceBlackList = Arrays.asList(this.config.getStringList("resourceBlackList", "resources", new String[]{"Aluminum", "Alumina", "Chrome", "Constantan"}, "resources to be black-listed.\nthis exists to avoid duplicates.\nthis affect the API."));
            this.customUnifiedResources = Collections.unmodifiableMap(this.getCustomUnifiedResourcesMap());
            this.userRegisteredOreDictEntries = Arrays.asList(this.config.getStringList("userRegisteredOreDictEntries", "general", new String[0], "This allows to the user register their own ore entries before the Unification happen.\nthis is mainly useful when the user is trying to unify things that aren't registered previously in the Ore Dictionary.\n\nFormat:\nweirdStone+minecraft:stone#1\nThe example above will register Granite as weirdStone."));
            this.integrationModule = this.config.getBoolean("integration", "modules", true, "Integration Module enabled?\nif false all the Integrations will be disabled.\n");
            this.craftingIntegration = this.config.getBoolean("craftingIntegration", "vanillaIntegrations", true, "Crafting Integration");
            this.furnaceIntegration = this.config.getBoolean("furnaceIntegration", "vanillaIntegrations", true, "Furnace Integration");
            this.forestry = Loader.isModLoaded((String)"forestry");
            this.ic2 = Loader.isModLoaded((String)"IC2");
            String integrations = "integrations";
            this.abyssalCraft = this.config.getBoolean("abyssalCraft", "integrations", true, "AbyssalCraft Integration.") && Loader.isModLoaded((String)"abyssalcraft");
            this.ae2Integration = this.config.getBoolean("appliedEnergistics2", "integrations", true, "Applied Energistics 2 Integration.") && Loader.isModLoaded((String)"appliedenergistics2");
            this.baseMetalsIntegration = this.config.getBoolean("baseMetals", "integrations", true, "Base Metals Integration.") && Loader.isModLoaded((String)"basemetals");
            this.bloodMagicIntegration = this.config.getBoolean("bloodMagic", "integrations", true, "Blood Magic Integration.") && Loader.isModLoaded((String)"BloodMagic");
            this.calculatorIntegration = this.config.getBoolean("calculator", "integrations", false, "Calculator Integration.") && Loader.isModLoaded((String)"Calculator");
            this.enderIOIntegration = this.config.getBoolean("enderIO", "integrations", true, "Ender IO Integration.") && Loader.isModLoaded((String)"EnderIO");
            this.forestryIntegration = this.config.getBoolean("forestry", "integrations", true, "Forestry Integration.") && this.forestry;
            this.foundryIntegration = this.config.getBoolean("foundry", "integrations", true, "Foundry Integration.") && Loader.isModLoaded((String)"foundry");
            this.ic2Integration = this.config.getBoolean("industrialCraft2", "integrations", true, "Industrial Craft 2 Integration.") && this.ic2;
            this.ieIntegration = this.config.getBoolean("immersiveEngineering", "integrations", true, "Immersive Engineering Integration.") && Loader.isModLoaded((String)"immersiveengineering");
            this.mekanismIntegration = this.config.getBoolean("mekanism", "integrations", true, "Mekanism Integration.") && Loader.isModLoaded((String)"Mekanism");
            this.modularMachinesIntegration = this.config.getBoolean("modularMachines", "integrations", true, "Modular-Machines Integration.") && Loader.isModLoaded((String)"modularmachines");
            this.railCraftIntegration = this.config.getBoolean("railcraft", "integrations", true, "Railcraft Integration.") && Loader.isModLoaded((String)"Railcraft");
            this.techRebornIntegration = this.config.getBoolean("techReborn", "integrations", true, "TechReborn Integration.") && Loader.isModLoaded((String)"techreborn");
        }
        catch (Exception e) {
            throw new RuntimeException("Something went wrong on " + this.config.getConfigFile() + " loading. " + e);
        }
        if (this.config.hasChanged() || deleted) {
            this.config.save();
        }
    }

    public void saveIfHasChanged() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public TObjectIntMap<String> getOwnerOfEveryKindMap(int kind) {
        String kindName = WordUtils.capitalize((String)Resource.getNameOfKind(kind));
        String[] ownerOfEveryKind = this.config.getStringList("ownerOfEvery" + kindName, "resources", new String[]{"minecraft", "substratum", "ic2", "mekanism", "immersiveengineering", "techreborn"}, "entries of kind \"" + kindName + "\" will be sorted according to the modID list below\nmust be the exact modID.\n");
        TObjectIntHashMap ownerOfEveryThingMap = new TObjectIntHashMap(10, 1.0f, Integer.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryKind.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryKind[i], i);
        }
        return ownerOfEveryThingMap;
    }

    private TObjectIntMap<String> getOwnerOfEveryThingMap() {
        String[] ownerOfEveryThing = this.config.getStringList("ownerOfEveryThing", "resources", new String[]{"minecraft", "substratum", "ic2", "mekanism", "immersiveengineering", "techreborn"}, "all the entries will be sorted according to the modID list below\nmust be the exact modID.\n");
        TObjectIntHashMap ownerOfEveryThingMap = new TObjectIntHashMap(10, 1.0f, Integer.MAX_VALUE);
        for (int i = 0; i < ownerOfEveryThing.length; ++i) {
            ownerOfEveryThingMap.put((Object)ownerOfEveryThing[i], i);
        }
        return ownerOfEveryThingMap;
    }

    private Map<String, Set<String>> getCustomUnifiedResourcesMap() {
        THashMap customUnifiedResources = new THashMap();
        Pattern splitPattern = Pattern.compile("\\|");
        for (String customUnifiedResource : this.config.getStringList("customUnifiedResources", "resources", new String[]{"Obsidian:dustTiny|dust", "Stone:dust", "Obsidian:dust|dustSmall", "Coal:dust|dustSmall", "Sulfur:dust|dustSmall", "Salt:dust"}, "Here you can put a list to custom unify them.\nmust be in this format \"ResourceName:kind1|kind2|...\".")) {
            LinkedHashSet kindSet;
            int baseSeparatorIndex = customUnifiedResource.indexOf(58);
            if (baseSeparatorIndex == -1 || (kindSet = Sets.newLinkedHashSet(Arrays.asList(splitPattern.split(customUnifiedResource.substring(baseSeparatorIndex + 1, customUnifiedResource.length()))))).isEmpty()) continue;
            customUnifiedResources.put(customUnifiedResource.substring(0, baseSeparatorIndex), kindSet);
        }
        return customUnifiedResources;
    }
}

