/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.common;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.resource.ResourceHandler;

public final class SpecificKindItemStackComparator
implements Comparator<ItemStack> {
    private static TIntObjectMap<SpecificKindItemStackComparator> kindSpecificComparators = new TIntObjectHashMap();
    private final TObjectIntMap<String> ownerOfKind;

    private SpecificKindItemStackComparator(int kind) {
        this.ownerOfKind = UniDict.getConfig().getOwnerOfEveryKindMap(kind);
        if (this.ownerOfKind == null) {
            throw new RuntimeException("this exception should be called: ThisShouldNeverHappenException.");
        }
    }

    public static synchronized SpecificKindItemStackComparator getComparatorFor(int kind) {
        if (!kindSpecificComparators.containsKey(kind)) {
            kindSpecificComparators.put(kind, (Object)new SpecificKindItemStackComparator(kind));
        }
        return (SpecificKindItemStackComparator)kindSpecificComparators.get(kind);
    }

    public static void nullify() {
        kindSpecificComparators = null;
    }

    @Override
    public int compare(@Nonnull ItemStack itemStack1, @Nonnull ItemStack itemStack2) {
        String stack1ModName = Util.getModName(itemStack1);
        Config config = UniDict.getConfig();
        if (config.keepOneEntry && config.keepOneEntryModBlackSet.contains(stack1ModName)) {
            ResourceHandler.addToKeepOneEntryModBlackSet(itemStack1);
        }
        return this.getIndex(stack1ModName) < this.getIndex(itemStack2) ? -1 : 0;
    }

    private long getIndex(ItemStack itemStack) {
        return this.ownerOfKind.get((Object)Util.getModName(itemStack));
    }

    private long getIndex(String modName) {
        return this.ownerOfKind.get((Object)modName);
    }
}

