/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import appeng.api.AEApi;
import appeng.api.features.IGrinderEntry;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class AE2Integration
extends AbstractIntegrationThread {
    AE2Integration() {
        super("Applied Energistics 2");
    }

    @Override
    public String call() {
        try {
            this.fixGrindStoneRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world of energistics has never been so powerful.";
    }

    private void fixGrindStoneRecipes() {
        List grindStoneRecipeList = AEApi.instance().registries().grinder().getRecipes();
        TIntHashSet uniques = new TIntHashSet(grindStoneRecipeList.size(), 1.0f);
        Iterator grindStoneRecipeIterator = grindStoneRecipeList.iterator();
        while (grindStoneRecipeIterator.hasNext()) {
            int recipeId;
            IGrinderEntry grindStoneRecipe = (IGrinderEntry)grindStoneRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(grindStoneRecipe.getOutput());
            if (correctOutput == grindStoneRecipe.getOutput()) continue;
            if (this.config.keepOneEntry) {
                grindStoneRecipe.setInput(this.resourceHandler.getMainItemStack(grindStoneRecipe.getInput()));
            }
            if (!uniques.contains(recipeId = MetaItem.getCumulative(grindStoneRecipe.getInput(), correctOutput))) {
                uniques.add(recipeId);
                grindStoneRecipe.setOutput(correctOutput);
                if (grindStoneRecipe.getOptionalOutput() != null) {
                    grindStoneRecipe.setOptionalOutput(this.resourceHandler.getMainItemStack(grindStoneRecipe.getOptionalOutput()), grindStoneRecipe.getOptionalChance());
                }
                if (grindStoneRecipe.getSecondOptionalOutput() == null) continue;
                grindStoneRecipe.setSecondOptionalOutput(this.resourceHandler.getMainItemStack(grindStoneRecipe.getSecondOptionalOutput()), grindStoneRecipe.getSecondOptionalChance());
                continue;
            }
            grindStoneRecipeIterator.remove();
        }
    }
}

