/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.recipe.BasicMachineRecipeManager;
import java.util.List;
import java.util.Map;
import wanion.unidict.UniDict;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IC2Integration
extends AbstractIntegrationThread {
    private final List<Map<IRecipeInput, RecipeOutput>> ic2MachinesRecipeList = new FixedSizeList<Map<IRecipeInput, RecipeOutput>>(5);

    IC2Integration() {
        super("Industrial Craft 2");
        try {
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, "recipes", Recipes.centrifuge, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, "recipes", Recipes.compressor, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, "recipes", Recipes.blastfurnace, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, "recipes", Recipes.macerator, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, "recipes", Recipes.metalformerRolling, Map.class));
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
    }

    @Override
    public String call() {
        this.ic2MachinesRecipeList.forEach(map -> {
            try {
                this.fixMachinesOutputs((Map<IRecipeInput, RecipeOutput>)map);
            }
            catch (Exception e) {
                UniDict.getLogger().error(this.threadName + e);
            }
        });
        return this.threadName + "The world appears to be entirely industrialized.";
    }

    private void fixMachinesOutputs(Map<IRecipeInput, RecipeOutput> recipes) {
        for (Map.Entry<IRecipeInput, RecipeOutput> recipe : recipes.entrySet()) {
            recipe.setValue(new RecipeOutput(recipe.getValue().metadata, this.resourceHandler.getMainItemStackList(recipe.getValue().items)));
        }
    }
}

