/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.recipe.AdvRecipe;
import ic2.core.recipe.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.unidict.MetaItem;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;

public class IC2RecipeResearcher
implements IRecipeResearcher<AdvRecipe, AdvShapelessRecipe> {
    @Override
    public int getShapedRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (IRecipeInput input : ((AdvRecipe)recipe).input) {
            List bufferInput = input.getInputs();
            if (bufferInput.isEmpty()) continue;
            recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)bufferInput.get(0))));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    public int getShapelessRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (IRecipeInput input : ((AdvShapelessRecipe)recipe).input) {
            List bufferInput = input.getInputs();
            if (bufferInput.isEmpty()) continue;
            recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)bufferInput.get(0))));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    @Nonnull
    public List<Class<? extends AdvRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(AdvRecipe.class);
    }

    @Override
    @Nonnull
    public List<Class<? extends AdvShapelessRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(AdvShapelessRecipe.class);
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] newRecipeInputs = new Object[9];
        IRecipeInput[] recipeInputs = ((AdvRecipe)recipe).input;
        for (int i = 0; i < 9; ++i) {
            String secondaryBufferOreName;
            String bufferOreName;
            List input = i < recipeInputs.length && !recipeInputs[i].getInputs().isEmpty() ? recipeInputs[i].getInputs() : null;
            String string = bufferOreName = input != null ? uniOreDictionary.getName(input) : null;
            newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : ((secondaryBufferOreName = uniOreDictionary.getName(input.get(0))) != null ? secondaryBufferOreName : null)) : null;
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] newRecipeInputs = new Object[9];
        IRecipeInput[] recipeInputs = ((AdvShapelessRecipe)recipe).input;
        for (int i = 0; i < recipeInputs.length; ++i) {
            String secondaryBufferOreName;
            String bufferOreName;
            List input = i < recipeInputs.length && !recipeInputs[i].getInputs().isEmpty() ? recipeInputs[i].getInputs() : null;
            String string = bufferOreName = input != null ? uniOreDictionary.getName(input) : null;
            newRecipeInputs[i] = input != null ? (bufferOreName != null ? bufferOreName : ((secondaryBufferOreName = uniOreDictionary.getName(input.get(0))) != null ? secondaryBufferOreName : null)) : null;
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> inputs = new ArrayList<String>();
        for (IRecipeInput recipeInput : ((AdvShapelessRecipe)recipe).input) {
            String bufferOreName = uniOreDictionary.getName(recipeInput.getInputs());
            if (bufferOreName != null) {
                inputs.add(bufferOreName);
                continue;
            }
            if (recipeInput.getInputs().isEmpty()) continue;
            bufferOreName = uniOreDictionary.getName(recipeInput.getInputs().get(0));
            if (bufferOreName != null) {
                inputs.add(bufferOreName);
                continue;
            }
            inputs.add((String)recipeInput.getInputs().get(0));
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> inputs = new ArrayList<String>();
        for (IRecipeInput recipeInput : ((AdvRecipe)recipe).input) {
            String bufferOreName = uniOreDictionary.getName(recipeInput.getInputs());
            if (bufferOreName != null) {
                inputs.add(bufferOreName);
                continue;
            }
            if (recipeInput.getInputs().isEmpty()) continue;
            bufferOreName = uniOreDictionary.getName(recipeInput.getInputs().get(0));
            if (bufferOreName != null) {
                inputs.add(bufferOreName);
                continue;
            }
            inputs.add((String)recipeInput.getInputs().get(0));
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), inputs.toArray());
    }
}

