/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import gnu.trove.TIntCollection;
import gnu.trove.impl.unmodifiable.TUnmodifiableIntObjectMap;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import wanion.unidict.resource.UniResourceContainer;

public class Resource {
    private static final TObjectIntMap<String> nameToKind = new TObjectIntHashMap();
    private static final TIntObjectMap<String> kindToName = new TIntObjectHashMap();
    private static int totalKindsRegistered = 0;
    public final String name;
    private final TIntObjectMap<UniResourceContainer> childrenMap = new TIntObjectHashMap();
    private final List<Resource> copies = new ArrayList<Resource>();
    private TIntSet children = new TIntHashSet();
    private boolean updated;

    public Resource(@Nonnull String name) {
        this.name = name;
    }

    public Resource(@Nonnull String name, @Nonnull TIntObjectMap<UniResourceContainer> containerMap) {
        this.name = name;
        containerMap.forEachValue(container -> this.childrenMap.put(container.kind, container) == null);
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, String ... kinds) {
        TIntArrayList kindList = new TIntArrayList();
        for (String kindName : kinds) {
            int kind = Resource.getKindOfName(kindName);
            if (kind == 0) {
                return Collections.emptyList();
            }
            kindList.add(kind);
        }
        return Resource.getResources(resources, (TIntList)kindList);
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, TIntList kinds) {
        return kinds.size() > 0 ? resources.stream().filter(resource -> resource.childrenExists(kinds)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, int ... kinds) {
        TIntArrayList kindList = new TIntArrayList();
        for (int kind : kinds) {
            if (kind == 0) {
                return Collections.emptyList();
            }
            kindList.add(kind);
        }
        return Resource.getResources(resources, (TIntList)kindList);
    }

    public static List<String> getKinds() {
        return Collections.unmodifiableList(new ArrayList(nameToKind.keySet()));
    }

    public static int getKindOfName(@Nonnull String name) {
        return nameToKind.get((Object)name);
    }

    public static String getNameOfKind(int kind) {
        return (String)kindToName.get(kind);
    }

    public static TIntList kindNamesToKindList(@Nonnull String[] kindNames) {
        TIntArrayList kindList = new TIntArrayList();
        for (String kindName : kindNames) {
            int bufferKind = Resource.getKindOfName(kindName);
            if (bufferKind == 0) continue;
            kindList.add(bufferKind);
        }
        return kindList;
    }

    public static boolean kindExists(@Nonnull String name) {
        return nameToKind.containsKey((Object)name);
    }

    public static boolean kindExists(String ... names) {
        for (String name : names) {
            if (nameToKind.containsKey((Object)name)) continue;
            return false;
        }
        return true;
    }

    public static int registerAndGet(@Nonnull String kindName) {
        if (nameToKind.containsKey((Object)kindName)) {
            return nameToKind.get((Object)kindName);
        }
        int kind = ++totalKindsRegistered;
        nameToKind.put((Object)kindName, kind);
        kindToName.put(kind, (Object)kindName);
        return kind;
    }

    public static void register(@Nonnull String kindName) {
        if (nameToKind.containsKey((Object)kindName)) {
            return;
        }
        int kind = ++totalKindsRegistered;
        nameToKind.put((Object)kindName, kind);
        kindToName.put(kind, (Object)kindName);
    }

    public boolean childExists(int kind) {
        return this.childrenMap.containsKey(kind);
    }

    public boolean childrenExists(TIntList kindList) {
        return this.childrenMap.keySet().containsAll((TIntCollection)kindList);
    }

    public UniResourceContainer getChild(@Nonnull String childName) {
        return (UniResourceContainer)this.childrenMap.get(nameToKind.get((Object)childName));
    }

    public UniResourceContainer getChild(int kind) {
        return (UniResourceContainer)this.childrenMap.get(kind);
    }

    public int getChildrenCount() {
        return this.childrenMap.size();
    }

    public Resource filteredClone(TIntList kindList) {
        TIntObjectHashMap newChildrenMap = new TIntObjectHashMap();
        TIntHashSet kindSet = new TIntHashSet((TIntCollection)kindList);
        this.childrenMap.forEachEntry((arg_0, arg_1) -> Resource.lambda$filteredClone$2((TIntSet)kindSet, (TIntObjectMap)newChildrenMap, arg_0, arg_1));
        Resource copiedResource = new Resource(this.name, (TIntObjectMap<UniResourceContainer>)newChildrenMap);
        this.copies.add(copiedResource);
        return copiedResource;
    }

    public boolean addChild(@Nonnull UniResourceContainer child) {
        long kind = child.kind;
        if (this.childrenMap.containsKey(child.kind) || !child.name.endsWith(this.name)) {
            return false;
        }
        this.childrenMap.put(child.kind, (Object)child);
        return true;
    }

    public void updateEntries() {
        if (this.updated) {
            return;
        }
        this.updated = true;
        TIntIterator childrenIterator = this.childrenMap.keySet().iterator();
        while (childrenIterator.hasNext()) {
            int kindId = childrenIterator.next();
            if (((UniResourceContainer)this.childrenMap.get(kindId)).updateEntries()) continue;
            childrenIterator.remove();
        }
        this.copies.forEach(Resource::updateEntries);
    }

    public Collection<UniResourceContainer> getChildrenCollection() {
        return this.childrenMap.valueCollection();
    }

    public String toString() {
        if (this.childrenMap.isEmpty()) {
            return this.name + " = {}";
        }
        StringBuilder output = new StringBuilder(this.name + " = {");
        TIntIterator childrenIterator = this.childrenMap.keySet().iterator();
        while (childrenIterator.hasNext()) {
            output.append((String)kindToName.get(childrenIterator.next())).append(childrenIterator.hasNext() ? ", " : "}");
        }
        return output.toString();
    }

    TIntObjectMap<UniResourceContainer> getChildrenMap() {
        return new TUnmodifiableIntObjectMap(this.childrenMap);
    }

    Resource setSortOfChildren(boolean sort) {
        this.childrenMap.forEachValue(child -> {
            child.setSort(sort);
            return true;
        });
        return this;
    }

    private static /* synthetic */ boolean lambda$filteredClone$2(TIntSet kindSet, TIntObjectMap newChildrenMap, int child, UniResourceContainer container) {
        if (kindSet.contains(child)) {
            newChildrenMap.put(child, (Object)container);
        }
        return true;
    }
}

