/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import com.google.common.collect.Sets;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import wanion.unidict.Config;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.common.Dependencies;
import wanion.unidict.common.Reference;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceContainer;

public final class UniResourceHandler {
    private static final TLongSet kindBlackSet = new TLongHashSet();
    private static boolean hasInit;
    private final Map<String, Resource> apiResourceMap = new THashMap();
    private final Map<String, Resource> resourceMap = new THashMap();
    private final Dependencies<UniDict.IDependence> dependencies = UniDict.getDependencies();
    private final Config config = UniDict.getConfig();

    private UniResourceHandler() {
        this.dependencies.subscribe((Dependencies.DependenceWatcher<UniDict.IDependence>)new Dependencies.DependenceWatcher<UniDictAPI>(this.dependencies){

            @Override
            @Nonnull
            public UniDictAPI instantiate() {
                return new UniDictAPI(Collections.unmodifiableMap(UniResourceHandler.this.apiResourceMap));
            }
        });
        this.dependencies.subscribe((Dependencies.DependenceWatcher<UniDict.IDependence>)new Dependencies.DependenceWatcher<ResourceHandler>(this.dependencies){

            @Override
            @Nonnull
            public ResourceHandler instantiate() {
                return new ResourceHandler(Collections.unmodifiableMap(UniResourceHandler.this.resourceMap));
            }
        });
    }

    public static UniResourceHandler create() {
        if (hasInit) {
            return null;
        }
        hasInit = true;
        return new UniResourceHandler();
    }

    static TLongSet getKindBlackSet() {
        if (kindBlackSet.isEmpty()) {
            UniDict.getConfig().hideInJEIBlackSet.forEach(blackKind -> kindBlackSet.add((long)Resource.getKindOfName(blackKind)));
        }
        return kindBlackSet;
    }

    public void init() {
        this.registerCustomEntries();
        this.createResources();
    }

    private void registerCustomEntries() {
        this.config.userRegisteredOreDictEntries.forEach(customEntries -> {
            String itemName;
            int separatorChar;
            Item item;
            int plusSeparator = customEntries.indexOf(43);
            if (plusSeparator != -1 && plusSeparator > 0 && (item = (Item)MetaItem.itemRegistry.getObject(new ResourceLocation((separatorChar = (itemName = customEntries.substring(plusSeparator + 1, customEntries.length())).indexOf(35)) == -1 ? itemName : itemName.substring(0, separatorChar)))) != null) {
                try {
                    int metadata = separatorChar == -1 ? 0 : Integer.parseInt(itemName.substring(separatorChar + 1, itemName.length()));
                    OreDictionary.registerOre((String)customEntries.substring(0, plusSeparator), (ItemStack)new ItemStack(item, 1, metadata));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createResources() {
        List allTheResourceNames = Collections.synchronizedList(new ArrayList());
        Pattern resourceBlackTagsPattern = Pattern.compile(".*(?i)(Dense|Nether|Dye|Glass|Tiny|Small|ore).*");
        ((Stream)UniOreDictionary.getThoseThatMatches("^ingot").parallelStream().filter(matcher -> !resourceBlackTagsPattern.matcher(matcher.replaceFirst("")).find()).parallel()).forEach(matcher -> allTheResourceNames.add(WordUtils.capitalize((String)matcher.replaceFirst(""))));
        StringBuilder patternBuilder = new StringBuilder("(");
        Iterator allTheResourceNamesIterator = allTheResourceNames.iterator();
        while (allTheResourceNamesIterator.hasNext()) {
            patternBuilder.append((String)allTheResourceNamesIterator.next()).append(allTheResourceNamesIterator.hasNext() ? "|" : ")$");
        }
        HashMap<String, Set> basicResourceMap = new HashMap<String, Set>();
        LinkedHashSet allTheKinds = new LinkedHashSet();
        HashSet allTheKindsBlackSet = Sets.newHashSet((Object[])new String[]{"stair", "bars", "fence", "trapdoor", "stairs", "bucketLiquid", "slab", "crystal", "stick", "orePoor", "oreChargedCertus", "slabNether", "bucketDust", "oreCoralium", "gem", "sapling", "pulp", "item", "stone", "wood", "crop", "bottleLiquid", "quartz", "log", "mana", "chest", "crafter", "material", "leaves", "oreCertus", "crystalSHard", "eternalLife", "blockPrismarine", "door", "bells", "arrow", "itemCompressed", "enlightenedFused", "darkFused", "crystalShard", "food", "hardened"});
        UniOreDictionary.getThoseThatMatches(Pattern.compile(patternBuilder.toString())).forEach(matcher -> {
            String kindName = matcher.replaceFirst("");
            if (!allTheKindsBlackSet.contains(kindName)) {
                String resourceName = matcher.group();
                if (!basicResourceMap.containsKey(resourceName)) {
                    basicResourceMap.put(resourceName, new LinkedHashSet());
                }
                ((Set)basicResourceMap.get(resourceName)).add(kindName);
                allTheKinds.add(kindName);
            }
        });
        allTheKinds.forEach(Resource::register);
        if (this.config.kindDebugMode) {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File("." + Reference.SLASH + "logs" + Reference.SLASH + "kindDebugLog.txt")));){
                allTheKinds.forEach(kind -> {
                    try {
                        bw.write((String)kind);
                        bw.newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        basicResourceMap.forEach((resourceName, kinds) -> {
            TIntObjectHashMap kindMap = new TIntObjectHashMap();
            kinds.forEach(kindName -> {
                int kind = Resource.getKindOfName(kindName);
                kindMap.put(kind, (Object)new UniResourceContainer(kindName + resourceName, kind));
            });
            this.apiResourceMap.put((String)resourceName, new Resource((String)resourceName, (TIntObjectMap<UniResourceContainer>)kindMap));
        });
        TIntList kindList = Resource.kindNamesToKindList(this.config.childrenOfMetals.toArray(new String[this.config.childrenOfMetals.size()]));
        this.config.metalsToUnify.stream().filter(this.apiResourceMap::containsKey).forEach(resourceName -> this.resourceMap.put((String)resourceName, this.apiResourceMap.get(resourceName).filteredClone(kindList).setSortOfChildren(true)));
        if (!this.config.customUnifiedResources.isEmpty()) {
            this.config.customUnifiedResources.forEach((resourceName, kinds) -> {
                Resource customResource = this.resourceMap.containsKey(resourceName) ? this.resourceMap.get(resourceName) : new Resource((String)resourceName);
                kinds.forEach(kindName -> {
                    String oreDictName = kindName + resourceName;
                    if (OreDictionary.doesOreNameExist((String)oreDictName)) {
                        customResource.addChild(new UniResourceContainer(oreDictName, Resource.registerAndGet(kindName), true));
                    }
                });
                if (!this.resourceMap.containsKey(resourceName) && customResource.getChildrenCount() != 0) {
                    this.resourceMap.put((String)resourceName, customResource);
                }
            });
        }
        this.config.saveIfHasChanged();
    }

    public void postInit() {
        this.apiResourceMap.values().parallelStream().forEach(Resource::updateEntries);
        for (String customEntry : this.config.customUnifiedResources.keySet()) {
            Resource customResource = this.resourceMap.get(customEntry);
            if (customResource == null) continue;
            customResource.updateEntries();
        }
        if (this.config.keepOneEntry) {
            OreDictionary.rebakeMap();
        }
        ResourceHandler resourceHandler = this.dependencies.get(ResourceHandler.class);
        resourceHandler.populateIndividualStackAttributes();
        for (String blackListedResource : this.config.resourceBlackList) {
            this.resourceMap.remove(blackListedResource);
            this.apiResourceMap.remove(blackListedResource);
        }
    }
}

