/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.gui;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CircuitType;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedstonePort;
import erogenousbeef.bigreactors.gui.controls.BeefGuiLabel;
import erogenousbeef.bigreactors.gui.controls.GuiSelectableButton;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.multiblock.ReactorRedstonePortChangeMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiReactorRedstonePort
extends BeefGuiBase {
    private TileEntityReactorRedstonePort port;
    BeefGuiLabel titleString;
    BeefGuiLabel settingString;
    private GuiButton commitBtn;
    private GuiButton resetBtn;
    private BeefGuiLabel subSettingLabel;
    private GuiButton subInputButton;
    private GuiButton subInputButton2;
    private BeefGuiLabel subInputRodSettingLabel;
    private GuiTextField subInputRodSetting;
    private BeefGuiLabel subInputRodSettingPctLabel;
    private BeefGuiLabel subInputRodSettingOffLabel;
    private GuiTextField subInputRodSettingOff;
    private BeefGuiLabel subInputRodSettingOffPctLabel;
    BeefGuiLabel subOutputValueLabel;
    private GuiTextField subOutputValue;
    private Map<CircuitType, GuiSelectableButton> btnMap;
    private int outputLevel;
    private boolean greaterThan;
    private boolean activeOnPulse;
    private boolean retract;
    private static final int MINIMUM_SETTING_SELECTOR_ID = 10;
    private static ResourceLocation s_backGround;

    public GuiReactorRedstonePort(Container container, TileEntityReactorRedstonePort tileentity) {
        super(container);
        this.port = tileentity;
        this.field_147000_g = 204;
        this.btnMap = new HashMap<CircuitType, GuiSelectableButton>();
        this.outputLevel = tileentity.getOutputLevel();
        this.greaterThan = tileentity.getGreaterThan();
        this.activeOnPulse = tileentity.isInputActiveOnPulse();
        if (this.outputLevel < 0) {
            this.retract = true;
            this.outputLevel = Math.abs(this.outputLevel);
        } else {
            this.retract = false;
        }
    }

    @Override
    public ResourceLocation getGuiBackground() {
        if (null == s_backGround) {
            s_backGround = BigReactors.createResourceLocation("textures/gui/RedstonePort.png");
        }
        return s_backGround;
    }

    private void registerCircuitButton(CircuitType ct, GuiSelectableButton btn) {
        this.btnMap.put(ct, btn);
        this.registerControl(btn);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int leftX = this.field_147003_i + 6;
        int topY = this.field_147009_r + 6;
        this.titleString = new BeefGuiLabel(this, "Reactor Redstone Port", leftX + 2, topY);
        this.settingString = new BeefGuiLabel(this, "Pick a setting", leftX, topY += this.titleString.getHeight() + 4);
        topY += this.settingString.getHeight() + 4;
        int buttonOrdinal = 10;
        leftX = this.field_147003_i + 16;
        CircuitType currentCircuitType = this.port.getCircuitType();
        for (CircuitType ct : CircuitType.values()) {
            if (ct == CircuitType.DISABLED) continue;
            GuiSelectableButton newBtn = new GuiSelectableButton(buttonOrdinal++, leftX, topY, ct.getIcon(), -16711936, this);
            newBtn.field_146126_j = ct.getTooltip();
            if (ct == currentCircuitType) {
                newBtn.setSelected(true);
            }
            if ((leftX += 28) > this.field_147003_i + 130) {
                topY += 28;
                leftX = this.field_147003_i + 16;
            }
            this.registerCircuitButton(ct, newBtn);
        }
        leftX = this.field_147003_i + 6;
        this.subSettingLabel = new BeefGuiLabel(this, "Settings", leftX, topY += 32);
        this.subInputButton = new GuiButton(2, leftX, topY += this.subSettingLabel.getHeight() + 4, 100, 20, "Activate on Pulse");
        this.subInputButton2 = new GuiButton(3, leftX + this.field_146999_f - 46, topY, 36, 20, "Mode");
        this.subInputRodSettingLabel = new BeefGuiLabel(this, "While On", leftX, topY += 24);
        this.subInputRodSettingOffLabel = new BeefGuiLabel(this, "While Off", leftX + this.field_146999_f / 2, topY);
        this.subOutputValue = new GuiTextField(1, this.field_146289_q, leftX, topY, 60, 12);
        this.subOutputValue.func_146205_d(true);
        this.subOutputValue.func_146203_f(7);
        this.subOutputValue.func_146180_a("0");
        this.subOutputValue.func_146184_c(true);
        this.subOutputValueLabel = new BeefGuiLabel(this, "C", leftX + 62, topY + 2);
        this.subInputRodSetting = new GuiTextField(2, this.field_146289_q, leftX, topY += this.subInputRodSettingLabel.getHeight() + 2, 32, 12);
        this.subInputRodSetting.func_146205_d(true);
        this.subInputRodSetting.func_146203_f(3);
        this.subInputRodSetting.func_146180_a("0");
        this.subInputRodSetting.func_146184_c(true);
        this.subInputRodSettingPctLabel = new BeefGuiLabel(this, "%", leftX + 34, topY + 2);
        this.subInputRodSettingOff = new GuiTextField(3, this.field_146289_q, leftX + this.field_146999_f / 2, topY, 32, 12);
        this.subInputRodSettingOff.func_146205_d(true);
        this.subInputRodSettingOff.func_146203_f(3);
        this.subInputRodSettingOff.func_146180_a("0");
        this.subInputRodSettingOff.func_146184_c(true);
        this.subInputRodSettingOffPctLabel = new BeefGuiLabel(this, "%", leftX + this.field_146999_f / 2 + 34, topY + 2);
        this.commitBtn = new GuiButton(0, this.field_147003_i + this.field_146999_f - 60, this.field_147009_r + this.field_147000_g - 24, 56, 20, "Commit");
        this.commitBtn.field_146124_l = false;
        this.resetBtn = new GuiButton(1, this.field_147003_i + 4, this.field_147009_r + this.field_147000_g - 24, 56, 20, "Reset");
        this.registerControl(this.titleString);
        this.registerControl(this.settingString);
        this.registerControl(this.subSettingLabel);
        this.registerControl(this.subInputButton);
        this.registerControl(this.subInputButton2);
        this.registerControl(this.subInputRodSettingLabel);
        this.registerControl(this.subInputRodSettingOffLabel);
        this.registerControl(this.subInputRodSetting);
        this.registerControl(this.subInputRodSettingOff);
        this.registerControl(this.subInputRodSettingPctLabel);
        this.registerControl(this.subInputRodSettingOffPctLabel);
        this.registerControl(this.subOutputValue);
        this.registerControl(this.subOutputValueLabel);
        this.registerControl(this.commitBtn);
        this.registerControl(this.resetBtn);
        if (currentCircuitType == CircuitType.inputSetControlRod) {
            this.subInputRodSetting.func_146180_a(Integer.toString(TileEntityReactorRedstonePort.unpackControlRodLevelOn(this.outputLevel)));
            this.subInputRodSettingOff.func_146180_a(Integer.toString(TileEntityReactorRedstonePort.unpackControlRodLevelOff(this.outputLevel)));
        } else if (currentCircuitType.isOutput()) {
            this.subOutputValue.func_146180_a(Integer.toString(this.outputLevel));
        }
        this.updateSubSettings(currentCircuitType);
        if (currentCircuitType.isInput()) {
            this.validateInputValues();
        } else {
            this.validateOutputValues();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        CircuitType selectedSetting = this.getUserSelectedCircuitType();
        this.updateSubSettings(selectedSetting);
        if (selectedSetting == this.port.getCircuitType()) {
            int actualOutputLevel = this.outputLevel;
            if (selectedSetting == CircuitType.inputSetControlRod && this.greaterThan && this.retract) {
                actualOutputLevel *= -1;
            }
            this.commitBtn.field_146124_l = this.activeOnPulse != this.port.isInputActiveOnPulse() || this.greaterThan != this.port.getGreaterThan() || actualOutputLevel != this.port.getOutputLevel();
        } else {
            this.commitBtn.field_146124_l = true;
        }
    }

    private void updateSubSettings(CircuitType selectedSetting) {
        this.subSettingLabel.setLabelText(this.getLabelFromSelectedSubSetting(selectedSetting));
        this.updateSubSettingInputButton(selectedSetting);
        this.updateSubSettingTextFields(selectedSetting);
    }

    private String getLabelFromSelectedSubSetting(CircuitType selectedSetting) {
        switch (selectedSetting) {
            case inputActive: {
                return "Input - Enable/Disable";
            }
            case inputEjectWaste: {
                return "Input - Eject Waste";
            }
            case inputSetControlRod: {
                return "Input - Control Rod Insertion";
            }
            case outputFuelAmount: {
                return "Output - Fuel Amount";
            }
            case outputWasteAmount: {
                return "Output - Waste Amount";
            }
            case outputFuelMix: {
                return "Output - Fuel Enrichment %";
            }
            case outputFuelTemperature: {
                return "Output - Fuel Temp (C)";
            }
            case outputCasingTemperature: {
                return "Output - Casing Temp (C)";
            }
            case outputEnergyAmount: {
                return "Output - Energy Amount (%)";
            }
        }
        return "";
    }

    private void updateSubSettingInputButton(CircuitType selectedSetting) {
        this.subInputButton.field_146125_m = true;
        this.subInputButton2.field_146125_m = false;
        switch (selectedSetting) {
            case inputActive: {
                this.subInputButton.field_146124_l = true;
                if (this.activeOnPulse) {
                    this.subInputButton.field_146126_j = "Toggle on Pulse";
                    break;
                }
                this.subInputButton.field_146126_j = "Set from Signal";
                break;
            }
            case inputSetControlRod: {
                this.subInputButton.field_146124_l = true;
                if (this.activeOnPulse) {
                    this.subInputButton2.field_146125_m = true;
                    if (this.greaterThan) {
                        if (this.retract) {
                            this.subInputButton.field_146126_j = "Retract on Pulse";
                            break;
                        }
                        this.subInputButton.field_146126_j = "Insert on Pulse";
                        break;
                    }
                    this.subInputButton.field_146126_j = "Set on Pulse";
                    break;
                }
                this.subInputButton.field_146126_j = "Set from Signal";
                break;
            }
            case inputEjectWaste: {
                this.subInputButton.field_146124_l = false;
                this.subInputButton.field_146126_j = "Eject on Pulse";
                break;
            }
            case outputFuelAmount: 
            case outputWasteAmount: 
            case outputFuelMix: 
            case outputFuelTemperature: 
            case outputCasingTemperature: 
            case outputEnergyAmount: {
                this.subInputButton.field_146124_l = true;
                if (this.greaterThan) {
                    this.subInputButton.field_146126_j = "Active While Above";
                    break;
                }
                this.subInputButton.field_146126_j = "Active While Below";
                break;
            }
            default: {
                this.subInputButton.field_146125_m = false;
            }
        }
    }

    private void updateSubSettingTextFields(CircuitType selectedSetting) {
        this.subOutputValueLabel.setLabelText("");
        this.subInputRodSettingLabel.setLabelText("");
        this.subInputRodSettingPctLabel.setLabelText("");
        this.subInputRodSettingOffLabel.setLabelText("");
        this.subInputRodSettingOffPctLabel.setLabelText("");
        this.subOutputValueLabel.setLabelTooltip("");
        this.subInputRodSetting.func_146189_e(false);
        this.subInputRodSettingOff.func_146189_e(false);
        this.subOutputValue.func_146189_e(false);
        switch (selectedSetting) {
            case outputFuelTemperature: 
            case outputCasingTemperature: {
                this.subOutputValueLabel.setLabelText("C");
                this.subOutputValueLabel.setLabelTooltip("Degrees centigrade");
                this.subOutputValue.func_146189_e(true);
                break;
            }
            case outputFuelMix: {
                this.subOutputValueLabel.setLabelText("%");
                this.subOutputValueLabel.setLabelTooltip("% of total contents, 0% if empty");
                this.subOutputValue.func_146189_e(true);
                break;
            }
            case outputEnergyAmount: {
                this.subOutputValueLabel.setLabelText("%");
                this.subOutputValueLabel.setLabelTooltip("% of energy buffer filled, 0% if empty");
                this.subOutputValue.func_146189_e(true);
                break;
            }
            case outputFuelAmount: {
                this.subOutputValueLabel.setLabelText("mB");
                this.subOutputValueLabel.setLabelTooltip("Milli-buckets");
                this.subOutputValue.func_146189_e(true);
                break;
            }
            case outputWasteAmount: {
                this.subOutputValueLabel.setLabelText("mB");
                this.subOutputValueLabel.setLabelTooltip("Milli-buckets");
                this.subOutputValue.func_146189_e(true);
                break;
            }
            case inputSetControlRod: {
                if (this.activeOnPulse) {
                    if (this.greaterThan) {
                        if (this.retract) {
                            this.subInputRodSettingLabel.setLabelText("Retract by");
                        } else {
                            this.subInputRodSettingLabel.setLabelText("Insert by");
                        }
                    } else {
                        this.subInputRodSettingLabel.setLabelText("Set to");
                    }
                } else {
                    this.subInputRodSettingLabel.setLabelText("While On");
                    this.subInputRodSettingOffLabel.setLabelText("While Off");
                    this.subInputRodSettingOffPctLabel.setLabelText("%");
                    this.subInputRodSettingOff.func_146189_e(true);
                }
                this.subInputRodSetting.func_146189_e(true);
                this.subInputRodSettingPctLabel.setLabelText("%");
                break;
            }
        }
    }

    protected void func_146284_a(GuiButton clickedButton) {
        if (clickedButton.field_146127_k == 0) {
            CircuitType newCircuitType = this.getUserSelectedCircuitType();
            int actualOutputLevel = this.outputLevel;
            if (newCircuitType == CircuitType.inputSetControlRod && this.greaterThan && this.retract) {
                actualOutputLevel *= -1;
            }
            CommonPacketHandler.INSTANCE.sendToServer((IMessage)new ReactorRedstonePortChangeMessage(this.port, newCircuitType.ordinal(), actualOutputLevel, this.greaterThan, this.activeOnPulse));
        } else if (clickedButton.field_146127_k == 1) {
            for (Map.Entry<CircuitType, GuiSelectableButton> pair : this.btnMap.entrySet()) {
                pair.getValue().setSelected(pair.getKey() == this.port.getCircuitType());
            }
            this.setSubSettingsToDefaults(this.port.getCircuitType());
        } else if (clickedButton.field_146127_k == 2) {
            CircuitType selectedCircuitType = this.getUserSelectedCircuitType();
            if (selectedCircuitType.isInput()) {
                this.activeOnPulse = !this.activeOnPulse;
            } else {
                this.greaterThan = !this.greaterThan;
            }
        } else if (clickedButton.field_146127_k == 3) {
            if (this.greaterThan && !this.retract) {
                this.greaterThan = true;
                this.retract = true;
            } else if (this.greaterThan && this.retract) {
                this.greaterThan = false;
                this.retract = false;
            } else {
                this.greaterThan = true;
                this.retract = false;
            }
        } else if (clickedButton.field_146127_k >= 10 && clickedButton.field_146127_k < 10 + this.btnMap.size()) {
            CircuitType ct = CircuitType.DISABLED;
            for (Map.Entry<CircuitType, GuiSelectableButton> pair : this.btnMap.entrySet()) {
                GuiSelectableButton btn = pair.getValue();
                btn.setSelected(btn.field_146127_k == clickedButton.field_146127_k);
                if (!btn.isSelected()) continue;
                ct = pair.getKey();
            }
            this.setSubSettingsToDefaults(ct);
        }
    }

    private void setSubSettingsToDefaults(CircuitType selectedType) {
        if (this.port.getCircuitType() == selectedType) {
            this.outputLevel = this.port.getOutputLevel();
            this.greaterThan = this.port.getGreaterThan();
            this.activeOnPulse = this.port.isInputActiveOnPulse();
            if (this.outputLevel < 0) {
                this.retract = true;
                this.outputLevel = Math.abs(this.outputLevel);
            } else {
                this.retract = false;
            }
        } else {
            this.greaterThan = true;
            this.activeOnPulse = false;
            this.outputLevel = 0;
            this.updateSubSettingTextFields(selectedType);
            if (selectedType.isInput()) {
                this.validateInputValues();
            } else {
                this.validateOutputValues();
            }
        }
        this.subInputRodSetting.func_146195_b(false);
        this.subInputRodSettingOff.func_146195_b(false);
        this.subOutputValue.func_146195_b(false);
    }

    private boolean isKeyValidForValueInput(int keyCode) {
        if (keyCode >= 2 && keyCode <= 11) {
            return true;
        }
        switch (keyCode) {
            case 14: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 203: 
            case 205: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    protected void func_73869_a(char inputChar, int keyCode) {
        boolean isAnyTextboxFocused;
        boolean bl = isAnyTextboxFocused = this.subInputRodSetting.func_146206_l() || this.subInputRodSettingOff.func_146206_l() || this.subOutputValue.func_146206_l();
        if (keyCode == 1 || !isAnyTextboxFocused && keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.isKeyValidForValueInput(keyCode)) {
            if (this.subInputRodSetting.func_146206_l()) {
                this.subInputRodSetting.func_146201_a(inputChar, keyCode);
                this.validateInputValues();
            }
            if (this.subInputRodSettingOff.func_146206_l()) {
                this.subInputRodSettingOff.func_146201_a(inputChar, keyCode);
                this.validateInputValues();
            }
            if (this.subOutputValue.func_146206_l()) {
                this.subOutputValue.func_146201_a(inputChar, keyCode);
                this.validateOutputValues();
            }
        }
        if (keyCode == 15) {
            if (this.subOutputValue.func_146206_l()) {
                this.subOutputValue.func_146195_b(false);
            } else if (this.subOutputValue.func_146176_q()) {
                this.subOutputValue.func_146195_b(true);
            }
            if (this.subInputRodSettingOff.func_146176_q()) {
                if (this.subInputRodSetting.func_146206_l()) {
                    this.subInputRodSetting.func_146195_b(false);
                    this.subInputRodSettingOff.func_146195_b(true);
                } else if (this.subInputRodSettingOff.func_146206_l()) {
                    this.subInputRodSettingOff.func_146195_b(false);
                } else {
                    this.subInputRodSetting.func_146195_b(true);
                }
            } else if (this.subInputRodSetting.func_146176_q()) {
                if (this.subInputRodSetting.func_146206_l()) {
                    this.subInputRodSetting.func_146195_b(false);
                } else {
                    this.subInputRodSetting.func_146195_b(true);
                }
            }
        }
        if (keyCode == 28 && isAnyTextboxFocused) {
            this.subInputRodSetting.func_146195_b(false);
            this.subInputRodSettingOff.func_146195_b(false);
            this.subOutputValue.func_146195_b(false);
        }
    }

    private void validateInputValues() {
        int val1;
        this.outputLevel = 0;
        String in1 = this.subInputRodSetting.func_146179_b();
        if (in1.isEmpty()) {
            val1 = 0;
        } else {
            val1 = Integer.parseInt(in1);
            if (val1 < 0) {
                val1 = 0;
            } else if (val1 > 100) {
                val1 = 100;
            }
        }
        this.subInputRodSetting.func_146180_a(Integer.toString(val1));
        if (this.subInputRodSettingOff.func_146176_q()) {
            int val2;
            String in2 = this.subInputRodSettingOff.func_146179_b();
            if (in2.isEmpty()) {
                val2 = 0;
            } else {
                val2 = Integer.parseInt(in2);
                if (val2 < 0) {
                    val2 = 0;
                } else if (val2 > 100) {
                    val2 = 100;
                }
            }
            this.outputLevel = val2 << 8 & 0xFF00;
            this.subInputRodSettingOff.func_146180_a(Integer.toString(val2));
        } else {
            this.outputLevel &= 0xFF00;
        }
        this.outputLevel |= val1 & 0xFF;
    }

    private void validateOutputValues() {
        int val1;
        String in1;
        CircuitType selectedType = this.getUserSelectedCircuitType();
        int maxVal = Integer.MAX_VALUE;
        if (selectedType == CircuitType.outputFuelMix || selectedType == CircuitType.outputEnergyAmount) {
            maxVal = 100;
        }
        if ((in1 = this.subOutputValue.func_146179_b()).isEmpty()) {
            val1 = 0;
        } else {
            val1 = Integer.parseInt(in1);
            if (val1 < 0) {
                val1 = 0;
            } else if (val1 > maxVal) {
                val1 = maxVal;
            }
        }
        this.subOutputValue.func_146180_a(Integer.toString(val1));
        this.outputLevel = val1;
    }

    private CircuitType getUserSelectedCircuitType() {
        for (Map.Entry<CircuitType, GuiSelectableButton> pair : this.btnMap.entrySet()) {
            if (!pair.getValue().isSelected()) continue;
            return pair.getKey();
        }
        return CircuitType.DISABLED;
    }
}

