/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockDevice;
import erogenousbeef.bigreactors.common.multiblock.block.PortDirection;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineFluidPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityReactorCreativeCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.creative.TileEntityTurbineCreativeSteamGenerator;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.utils.StaticUtils;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockMultiblockIOPort
extends BlockMultiblockDevice {
    public BlockMultiblockIOPort(PartType type, String blockName) {
        super(type, blockName);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case ReactorAccessPort: {
                return new TileEntityReactorAccessPort();
            }
            case ReactorCoolantPort: {
                return new TileEntityReactorCoolantPort();
            }
            case ReactorCreativeCoolantPort: {
                return new TileEntityReactorCreativeCoolantPort();
            }
            case TurbineFluidPort: {
                return new TileEntityTurbineFluidPort();
            }
            case TurbineCreativeSteamGenerator: {
                return new TileEntityTurbineCreativeSteamGenerator();
            }
        }
        throw new IllegalArgumentException("Unrecognized part");
    }

    @Override
    public void registerRecipes() {
        if (PartType.ReactorAccessPort == this._type) {
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                GameRegistry.addRecipe((ItemStack)this.createItemStack(PartTier.Legacy, 1), (Object[])new Object[]{"C C", " V ", "CPC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('V'), Blocks.field_150486_ae, Character.valueOf('P'), Blocks.field_150331_J});
            }
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                GameRegistry.addRecipe((ItemStack)this.createItemStack(PartTier.Basic, 1), (Object[])new Object[]{"C C", " V ", "CPC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('V'), Blocks.field_150486_ae, Character.valueOf('P'), Blocks.field_150331_J});
            }
        } else if (PartType.ReactorCoolantPort == this._type) {
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"C C", "IVI", "CPC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('V'), Items.field_151133_ar, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('I'), "ingotIron"}));
            }
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"C C", "IVI", "CPC", Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('V'), Items.field_151133_ar, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('I'), "ingotSteel"}));
            }
        } else if (PartType.TurbineFluidPort == this._type) {
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"H H", "IVI", "HPH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('I'), "ingotIron", Character.valueOf('V'), Items.field_151133_ar, Character.valueOf('P'), Blocks.field_150331_J}));
            }
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"H H", "IVI", "HPH", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('I'), "ingotSteel", Character.valueOf('V'), Items.field_151133_ar, Character.valueOf('P'), Blocks.field_150331_J}));
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        boolean hasWrench = StaticUtils.Inventory.isPlayerHoldingWrench(heldItem);
        if (te instanceof TileEntityReactorCreativeCoolantPort) {
            if (WorldHelper.calledByLogicalServer((World)world)) {
                TileEntityReactorCreativeCoolantPort cp = (TileEntityReactorCreativeCoolantPort)te;
                if (heldItem == null || hasWrench) {
                    cp.toggleDirection(true);
                } else {
                    cp.forceAddWater();
                }
            }
            return true;
        }
        if (hasWrench && te instanceof IInputOutputPort) {
            if (WorldHelper.calledByLogicalServer((World)world)) {
                ((IInputOutputPort)te).toggleDirection(true);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, position, neighbor);
        }
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.PORTDIRECTION});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.PORTDIRECTION, (Comparable)((Object)PortDirection.Inlet));
    }

    @Override
    protected IBlockState buildActualState(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part) {
        state = super.buildActualState(state, world, position, part);
        if (part instanceof IInputOutputPort) {
            state = state.func_177226_a(Properties.PORTDIRECTION, (Comparable)((Object)(((IInputOutputPort)part).getDirection().isInput() ? PortDirection.Inlet : PortDirection.Outlet)));
        }
        return state;
    }
}

