/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import erogenousbeef.bigreactors.common.multiblock.IPowerGenerator;
import erogenousbeef.bigreactors.common.multiblock.IPowerProvider;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.tileentity.PowerTapHandler;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

class PowerTapRedstoneFluxHandler
extends PowerTapHandler
implements IEnergyProvider {
    private IEnergyReceiver _consumer = null;

    public PowerTapRedstoneFluxHandler(RectangularMultiblockTileEntityBase part) {
        super(part);
    }

    @Override
    public boolean isProviderConnected() {
        return null != this._consumer;
    }

    @Override
    public long onProvidePower(long units) {
        int maxUnits = (int)Math.min(units, Integer.MAX_VALUE);
        EnumFacing approachDirection = this._part.getOutwardFacing();
        if (null == this._consumer || null == approachDirection) {
            return units;
        }
        int consumed = this._consumer.receiveEnergy(approachDirection, maxUnits, false);
        return maxUnits - consumed;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return null != this.getPowerGenerator(from);
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        IPowerGenerator generator = this.getPowerGenerator(from);
        return null == generator ? 0 : (int)generator.extractEnergy(Math.min((long)maxExtract, PowerSystem.RedstoneFlux.maxCapacity), simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        IPowerGenerator generator = this.getPowerGenerator(from);
        return null == generator ? 0 : (int)Math.min(generator.getEnergyStored(), PowerSystem.RedstoneFlux.maxCapacity);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        IPowerGenerator generator = this.getPowerGenerator(from);
        return null == generator ? 0 : (int)Math.min(generator.getEnergyCapacity(), PowerSystem.RedstoneFlux.maxCapacity);
    }

    @Override
    public void checkForConnections(IBlockAccess world, BlockPos position) {
        boolean wasConnected = null != this._consumer;
        EnumFacing approachDirection = this._part.getOutwardFacing();
        if (null == approachDirection) {
            wasConnected = false;
            this._consumer = null;
        } else {
            IEnergyReceiver handler;
            this._consumer = null;
            BlockPos targetPosition = position.func_177972_a(approachDirection);
            TileEntity te = world.func_175625_s(targetPosition);
            if (!(te instanceof IPowerProvider) && te instanceof IEnergyReceiver && (handler = (IEnergyReceiver)te).canConnectEnergy(approachDirection.func_176734_d())) {
                this._consumer = handler;
            }
        }
        boolean isConnected = null != this._consumer;
        World partWorld = this._part.func_145831_w();
        if (wasConnected != isConnected && WorldHelper.calledByLogicalClient((World)partWorld)) {
            WorldHelper.notifyBlockUpdate((World)partWorld, (BlockPos)this._part.getWorldPosition(), null, null);
        }
    }
}

