/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.client.gui.GuiReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.ControlRodUpdateMessage;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorControlRod
extends TileEntityReactorPart {
    public static final short maxInsertion = 100;
    public static final short minInsertion = 0;
    protected short controlRodInsertion = 0;
    protected String name = "";

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        MultiblockControllerBase controller = this.getMultiblockController();
        return null != controller && controller.isAssembled();
    }

    public short getControlRodInsertion() {
        return this.controlRodInsertion;
    }

    public void setControlRodInsertion(short newInsertion) {
        if (newInsertion > 100 || newInsertion < 0 || newInsertion == this.controlRodInsertion) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        this.controlRodInsertion = (short)Math.max(Math.min(newInsertion, 100), 0);
        this.sendControlRodUpdate();
    }

    public void setName(String newName) {
        if (this.name.equals(newName)) {
            return;
        }
        this.name = newName;
        if (!this.field_145850_b.field_72995_K) {
            WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
        }
    }

    public String getName() {
        return this.name;
    }

    public void onClientControlRodChange(int amount) {
        this.setControlRodInsertion((short)(this.controlRodInsertion + amount));
    }

    protected void sendControlRodUpdate() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos position = this.func_174877_v();
        CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new ControlRodUpdateMessage(position, this.controlRodInsertion), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 50.0));
    }

    @SideOnly(value=Side.CLIENT)
    public void onControlRodUpdate(short controlRodInsertion) {
        this.controlRodInsertion = controlRodInsertion;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (ModTileEntity.SyncReason.NetworkUpdate == syncReason) {
            this.readLocalDataFromNBT(data);
        } else if (data.func_74764_b("reactorControlRod")) {
            NBTTagCompound localData = data.func_74775_l("reactorControlRod");
            this.readLocalDataFromNBT(localData);
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
            }
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this.writeLocalDataToNBT(data);
        } else {
            NBTTagCompound localData = new NBTTagCompound();
            this.writeLocalDataToNBT(localData);
            data.func_74782_a("reactorControlRod", (NBTBase)localData);
        }
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return new ContainerBasic();
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return new GuiReactorControlRod(new ContainerBasic(), this);
    }

    @Override
    public boolean isGoodForFrame(IMultiblockValidator validatorCallback) {
        BlockPos position = this.func_174877_v();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_rods_position", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        return false;
    }

    @Override
    public boolean isGoodForSides(IMultiblockValidator validatorCallback) {
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            if (!this.checkForFuelRod(direction)) continue;
            return true;
        }
        BlockPos position = this.func_174877_v();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_rods_position", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        return false;
    }

    @Override
    public boolean isGoodForTop(IMultiblockValidator validatorCallback) {
        if (!this.checkForFuelRod(EnumFacing.DOWN)) {
            BlockPos position = this.func_174877_v();
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_rods_column", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            return false;
        }
        return true;
    }

    @Override
    public boolean isGoodForBottom(IMultiblockValidator validatorCallback) {
        if (!this.checkForFuelRod(EnumFacing.UP)) {
            BlockPos position = this.func_174877_v();
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_rods_position", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            return false;
        }
        return true;
    }

    @Override
    public boolean isGoodForInterior(IMultiblockValidator validatorCallback) {
        BlockPos position = this.func_174877_v();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_rods_position", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        return false;
    }

    private boolean checkForFuelRod(EnumFacing fuelDirection) {
        return null != fuelDirection && this.field_145850_b.func_175625_s(this.getWorldPosition().func_177972_a(fuelDirection)) instanceof TileEntityReactorFuelRod;
    }

    private void readLocalDataFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("controlRodInsertion")) {
            this.controlRodInsertion = data.func_74765_d("controlRodInsertion");
        }
        this.name = data.func_74764_b("name") ? data.func_74779_i("name") : "";
    }

    private void writeLocalDataToNBT(NBTTagCompound data) {
        data.func_74777_a("controlRodInsertion", this.controlRodInsertion);
        if (!this.name.isEmpty()) {
            data.func_74778_a("name", this.name);
        }
    }
}

