/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTurbineFluidPort
extends TileEntityTurbinePart
implements INeighborUpdatableEntity,
ITickableMultiblockPart,
IInputOutputPort {
    private IInputOutputPort.Direction _direction = IInputOutputPort.Direction.Input;
    private IFluidHandler _pumpDestination = null;

    @Override
    public IInputOutputPort.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setDirection(IInputOutputPort.Direction direction, boolean markForUpdate) {
        if (direction == this._direction) {
            return;
        }
        this._direction = direction;
        WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.getWorldPosition(), null, null);
        if (WorldHelper.calledByLogicalServer((World)this.field_145850_b)) {
            if (markForUpdate) {
                this.func_70296_d();
            } else {
                this.notifyNeighborsOfTileChange();
            }
        } else {
            this.notifyNeighborsOfTileChange();
        }
    }

    @Override
    public void toggleDirection(boolean markForUpdate) {
        this.setDirection(this._direction.opposite(), markForUpdate);
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase multiblockControllerBase) {
        super.onMachineAssembled(multiblockControllerBase);
        this.checkForAdjacentTank();
        this.notifyNeighborsOfTileChange();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this._pumpDestination = null;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (!data.func_74764_b("isInlet")) {
            return;
        }
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this._direction = IInputOutputPort.Direction.from(data.func_74767_n("isInlet"));
        } else {
            this.setDirection(IInputOutputPort.Direction.from(data.func_74767_n("isInlet")), false);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74757_a("isInlet", this._direction.isInput());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == capability && this.isConnected() || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        MultiblockTurbine turbine;
        if (CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == capability && null != (turbine = this.getTurbine())) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)turbine.getFluidHandler(this._direction));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onMultiblockServerTick() {
        if (null == this._pumpDestination || this._direction.isInput()) {
            return;
        }
        IFluidHandler fluidHandler = this.getTurbine().getFluidHandler(IInputOutputPort.Direction.Output);
        FluidStack fluidToDrain = fluidHandler.drain(4000, false);
        if (fluidToDrain != null && fluidToDrain.amount > 0) {
            fluidToDrain.amount = this._pumpDestination.fill(fluidToDrain, true);
            fluidHandler.drain(fluidToDrain, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos position, IBlockState stateAtPosition, Block neighborBlock) {
        if (WorldHelper.calledByLogicalServer((World)world)) {
            this.checkForAdjacentTank();
        }
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        if (!this.field_145850_b.field_72995_K) {
            this.checkForAdjacentTank();
        }
    }

    private void checkForAdjacentTank() {
        EnumFacing facing = this.getOutwardFacing();
        this._pumpDestination = null;
        if (null == facing || WorldHelper.calledByLogicalClient((World)this.field_145850_b) || this._direction.isInput()) {
            return;
        }
        TileEntity neighbor = this.field_145850_b.func_175625_s(this.getWorldPosition().func_177972_a(facing));
        facing = facing.func_176734_d();
        if (null != neighbor && neighbor.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            this._pumpDestination = (IFluidHandler)neighbor.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
    }
}

