/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventory;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileEntityPoweredInventoryFluid
extends TileEntityPoweredInventory
implements IFluidHandler,
IMultipleFluidHandler {
    private FluidTank[] tanks = new FluidTank[this.getNumTanks()];
    private FluidTank[][] tankExposureCache = new FluidTank[this.getNumTanks()][1];
    protected static final FluidTank[] kEmptyFluidTankList = new FluidTank[0];
    protected static final int FLUIDTANK_NONE = -1;

    public TileEntityPoweredInventoryFluid() {
        for (int i = 0; i < this.getNumTanks(); ++i) {
            this.tanks[i] = new FluidTank(this.getTankSize(i));
            this.tankExposureCache[i][0] = this.tanks[i];
        }
    }

    private void readFluidsFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].setFluid(null);
        }
        if (tag.func_74764_b("fluids")) {
            NBTTagList tagList = tag.func_150295_c("fluids", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound fluidTag = tagList.func_150305_b(i);
                int fluidIdx = fluidTag.func_74762_e("tagIdx");
                FluidStack newFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
                this.tanks[fluidIdx].setFluid(newFluid);
            }
        }
    }

    private void writeFluidsToNBT(NBTTagCompound tag) {
        NBTTagList fluidTagList = new NBTTagList();
        for (int i = 0; i < this.getNumTanks(); ++i) {
            if (this.tanks[i] == null || this.tanks[i].getFluid() == null) continue;
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluidTag.func_74768_a("tagIdx", i);
            this.tanks[i].getFluid().writeToNBT(fluidTag);
            fluidTagList.func_74742_a((NBTBase)fluidTag);
        }
        if (fluidTagList.func_74745_c() > 0) {
            tag.func_74782_a("fluids", (NBTBase)fluidTagList);
        }
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this.readFluidsFromNBT(data);
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this.writeFluidsToNBT(data);
        }
    }

    @Override
    protected void onSendUpdate(NBTTagCompound updateTag) {
        super.onSendUpdate(updateTag);
        this.writeFluidsToNBT(updateTag);
    }

    @Override
    public void onReceiveUpdate(NBTTagCompound updateTag) {
        super.onReceiveUpdate(updateTag);
        this.readFluidsFromNBT(updateTag);
    }

    public abstract int getNumTanks();

    public abstract int getTankSize(int var1);

    public abstract int getExposedTankFromSide(int var1);

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int tankToFill = -1;
        if (tankToFill <= -1) {
            return 0;
        }
        return this.fill(tankToFill, resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (!this.isFluidValidForTank(tankIndex, resource)) {
            return 0;
        }
        int res = this.tanks[tankIndex].fill(resource, doFill);
        return res;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        int tankToDrain = 0;
        if (tankToDrain <= -1) {
            return null;
        }
        return this.drain(tankToDrain, maxDrain, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tanks[tankIndex].drain(maxDrain, doDrain);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        int tankToDrain = 0;
        if (tankToDrain == -1) {
            return null;
        }
        if (!resource.isFluidEqual(this.tanks[tankToDrain].getFluid())) {
            return null;
        }
        return this.drain(tankToDrain, resource.amount, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        int tankIdx = 0;
        if (tankIdx == -1) {
            return false;
        }
        FluidTank tank = this.tanks[tankIdx];
        if (tank.getFluidAmount() <= 0) {
            return true;
        }
        return tank.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        int tankIdx = 0;
        if (tankIdx == -1) {
            return false;
        }
        FluidTank tank = this.tanks[tankIdx];
        if (tank.getFluidAmount() <= 0) {
            return false;
        }
        return tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.getTankInfo();
    }

    @Override
    public FluidTankInfo[] getTankInfo() {
        FluidTankInfo[] infos = new FluidTankInfo[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            infos[i] = this.tanks[i].getInfo();
        }
        return infos;
    }

    protected abstract boolean isFluidValidForTank(int var1, FluidStack var2);

    protected abstract int getDefaultTankForFluid(Fluid var1);
}

