/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.interfaces.IReactorFuelInfo;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiVerticalProgressBar;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BeefGuiFuelMixBar
extends BeefGuiVerticalProgressBar
implements IBeefTooltipControl {
    IReactorFuelInfo entity;
    protected double fuelLeftU = 0.25;
    protected double fuelRightU = 0.4999;
    protected double wasteLeftU = 0.5;
    protected double wasteRightU = 0.7499;
    private static final double maxV = 0.984375;
    private static final double minV = 0.015625;
    private static ResourceLocation s_bgTexture;

    public BeefGuiFuelMixBar(BeefGuiBase container, int x, int y, IReactorFuelInfo entity) {
        super(container, x, y);
        this.entity = entity;
    }

    @Override
    protected double getBackgroundLeftU() {
        return 0.0;
    }

    @Override
    protected double getBackgroundRightU() {
        return 0.2499;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        if (null == s_bgTexture) {
            s_bgTexture = BigReactors.createGuiResourceLocation("controls/FuelMixBar.png");
        }
        return s_bgTexture;
    }

    @Override
    protected void drawProgressBar(Tessellator tessellator, TextureManager renderEngine, int barMinX, int barMaxX, int barMinY, int barMaxY, int zLevel) {
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int barMaxHeight = this.height - 1;
        int barHeight = Math.max(1, Math.round(this.getProgress() * (float)barMaxHeight));
        double fullness = (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) / (double)this.entity.getCapacity();
        double fuelProportion = (double)this.entity.getFuelAmount() / (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount());
        double wasteProportion = (double)this.entity.getWasteAmount() / (double)(this.entity.getFuelAmount() + this.entity.getWasteAmount());
        renderEngine.func_110577_a(this.controlResource);
        if (fuelProportion > 0.0) {
            double fuelMinV = 1.0 - fullness * 0.984375;
            double fuelMaxV = 0.984375;
            vertexbuffer.func_181668_a(7, vertexbuffer.func_178973_g());
            vertexbuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height - 1), (double)zLevel).func_187315_a(this.fuelLeftU, fuelMaxV).func_181675_d();
            vertexbuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - 1), (double)zLevel).func_187315_a(this.fuelRightU, fuelMaxV).func_181675_d();
            vertexbuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - barHeight), (double)zLevel).func_187315_a(this.fuelRightU, fuelMinV).func_181675_d();
            vertexbuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height - barHeight), (double)zLevel).func_187315_a(this.fuelLeftU, fuelMinV).func_181675_d();
            tessellator.func_78381_a();
        }
        if (wasteProportion > 0.0) {
            double wasteMinV = 1.0 - fullness * wasteProportion * 0.984375;
            double wasteMaxV = 0.984375;
            double wasteHeight = Math.round((double)barHeight * wasteProportion);
            if (wasteHeight > 0.0) {
                double wasteTop = (double)(this.absoluteY + this.height - 1) - wasteHeight;
                vertexbuffer.func_181668_a(7, vertexbuffer.func_178973_g());
                vertexbuffer.func_181662_b((double)this.absoluteX, (double)(this.absoluteY + this.height - 1), (double)(zLevel + 1)).func_187315_a(this.wasteLeftU, wasteMaxV).func_181675_d();
                vertexbuffer.func_181662_b((double)(this.absoluteX + this.width), (double)(this.absoluteY + this.height - 1), (double)(zLevel + 1)).func_187315_a(this.wasteRightU, wasteMaxV).func_181675_d();
                vertexbuffer.func_181662_b((double)(this.absoluteX + this.width), wasteTop, (double)(zLevel + 1)).func_187315_a(this.wasteRightU, wasteMinV).func_181675_d();
                vertexbuffer.func_181662_b((double)this.absoluteX, wasteTop, (double)(zLevel + 1)).func_187315_a(this.wasteLeftU, wasteMinV).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }

    @Override
    public String[] getTooltip() {
        float depletion;
        float fullness = this.getProgress() * 100.0f;
        String wasteString = "Empty";
        String fuelString = "Empty";
        if (this.entity.getFuelAmount() + this.entity.getWasteAmount() == 0) {
            depletion = 0.0f;
        } else {
            depletion = (float)this.entity.getWasteAmount() / (float)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) * 100.0f;
            if (this.entity.getFuelAmount() > 0) {
                fuelString = Integer.toString(this.entity.getFuelAmount()) + " mB";
            }
            if (this.entity.getWasteAmount() > 0) {
                wasteString = Integer.toString(this.entity.getWasteAmount()) + " mB";
            }
        }
        return new String[]{TextFormatting.AQUA + "Core Fuel Status", String.format(" %2.1f%% full", Float.valueOf(fullness)), String.format(" %2.1f%% depleted", Float.valueOf(depletion)), "", String.format("Fuel Rods: %d", this.entity.getFuelRodCount()), String.format("Max Capacity: %d mB", this.entity.getCapacity()), String.format("Fuel: %s", fuelString), String.format("Waste: %s", wasteString), String.format("Total: %d mB", this.entity.getFuelAmount() + this.entity.getWasteAmount())};
    }

    @Override
    protected float getProgress() {
        return (float)(this.entity.getFuelAmount() + this.entity.getWasteAmount()) / (float)this.entity.getCapacity();
    }
}

