/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message;

import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.network.ModTileEntityMessage;
import it.zerono.mods.zerocore.lib.network.ModTileEntityMessageHandlerServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeviceChangeExposureMessage
extends ModTileEntityMessage {
    private int _side;
    private boolean _increment;

    public DeviceChangeExposureMessage() {
    }

    public DeviceChangeExposureMessage(BlockPos position, int side, boolean increment) {
        super(position);
        this._side = side;
        this._increment = increment;
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this._side = buffer.readInt();
        this._increment = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this._side);
        buffer.writeBoolean(this._increment);
    }

    public static class Handler
    extends ModTileEntityMessageHandlerServer<DeviceChangeExposureMessage> {
        protected void processTileEntityMessage(DeviceChangeExposureMessage message, MessageContext ctx, TileEntity tileEntity) {
            if (tileEntity instanceof TileEntityBeefBase) {
                TileEntityBeefBase beefTe = (TileEntityBeefBase)tileEntity;
                EnumFacing side = EnumFacing.field_82609_l[message._side];
                if (message._increment) {
                    beefTe.incrSide(side);
                } else {
                    beefTe.decrSide(side);
                }
            } else {
                BlockPos position = tileEntity.func_174877_v();
                BRLog.warning("Received SideChangeMessage for TE at %d, %d, %d, but it was not a TE with an iterable side exposure!", position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
            }
        }
    }
}

