/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.utils;

import erogenousbeef.bigreactors.utils.InventoryHelper;
import erogenousbeef.bigreactors.utils.SidedInventoryHelper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AdjacentInventoryHelper {
    private EnumFacing dir;
    private TileEntity entity;
    private InventoryHelper inv;

    public AdjacentInventoryHelper(EnumFacing dir) {
        this.dir = dir;
        this.entity = null;
        this.inv = null;
    }

    public ItemStack distribute(ItemStack itemToDistribute) {
        if (this.entity == null || itemToDistribute == null) {
            return itemToDistribute;
        }
        if (!this.hasConnection()) {
            return itemToDistribute;
        }
        if (this.inv != null) {
            itemToDistribute = this.inv.addItem(itemToDistribute);
        }
        return itemToDistribute;
    }

    public boolean hasConnection() {
        return this.inv != null;
    }

    public boolean set(TileEntity te) {
        if (this.entity == te) {
            return false;
        }
        if (te == null) {
            this.inv = null;
        } else if (te instanceof IInventory) {
            this.setInv(te);
        }
        this.entity = te;
        return true;
    }

    private void setInv(TileEntity te) {
        this.inv = null;
        if (te instanceof ISidedInventory) {
            this.inv = new SidedInventoryHelper((ISidedInventory)te, this.dir.func_176734_d());
        } else {
            BlockPos position;
            IInventory inv = (IInventory)te;
            World world = te.func_145831_w();
            IBlockState state = world.func_180495_p(position = te.func_174877_v());
            if (state.func_177230_c() == Blocks.field_150486_ae) {
                inv = StaticUtils.Inventory.checkForDoubleChest(world, inv, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
            }
            this.inv = new InventoryHelper(inv);
        }
    }
}

