/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.customConversions.CustomConversionMapper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.util.JsonUtils;

public final class CustomEMCParser {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CustomEMCEntry.class, (Object)new Serializer()).setPrettyPrinting().create();
    private static final File CONFIG = new File(PECore.CONFIG_DIR, "custom_emc.json");
    public static CustomEMCFile currentEntries;
    private static boolean dirty;

    public static void init() {
        CustomEMCParser.flush();
        if (!CONFIG.exists()) {
            try {
                if (CONFIG.createNewFile()) {
                    CustomEMCParser.writeDefaultFile();
                }
            }
            catch (IOException e) {
                PELogger.logFatal("Exception in file I/O: couldn't create custom configuration files.");
            }
        }
        try {
            currentEntries = (CustomEMCFile)GSON.fromJson((Reader)new BufferedReader(new FileReader(CONFIG)), CustomEMCFile.class);
        }
        catch (FileNotFoundException e) {
            PELogger.logFatal("Couldn't read custom emc file");
            currentEntries = new CustomEMCFile(new ArrayList<CustomEMCEntry>());
        }
    }

    private static NormalizedSimpleStack getNss(String str, int meta) {
        if (str.contains(":")) {
            return NormalizedSimpleStack.getFor(str, meta);
        }
        return NormalizedSimpleStack.forOreDictionary(str);
    }

    public static boolean addToFile(String toAdd, int meta, int emc) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toAdd, meta);
        for (CustomEMCEntry entry : CustomEMCParser.currentEntries.entries) {
            if (!entry.nss.equals(nss)) continue;
            return false;
        }
        CustomEMCParser.currentEntries.entries.add(new CustomEMCEntry(nss, emc));
        dirty = true;
        return true;
    }

    public static boolean removeFromFile(String toRemove, int meta) {
        NormalizedSimpleStack nss = CustomEMCParser.getNss(toRemove, meta);
        Iterator<CustomEMCEntry> iter = CustomEMCParser.currentEntries.entries.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!iter.next().nss.equals(nss)) continue;
            iter.remove();
            dirty = true;
            removed = true;
        }
        return removed;
    }

    private static void flush() {
        if (dirty) {
            try {
                Files.write((CharSequence)GSON.toJson((Object)currentEntries), (File)CONFIG, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            dirty = false;
        }
    }

    private static void writeDefaultFile() {
        JsonObject elem = (JsonObject)GSON.toJsonTree((Object)new CustomEMCFile(new ArrayList<CustomEMCEntry>()));
        elem.add("__comment", (JsonElement)new JsonPrimitive("Use the in-game commands to edit this file"));
        try {
            Files.write((CharSequence)GSON.toJson((JsonElement)elem), (File)CONFIG, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        dirty = false;
    }

    private static class Serializer
    implements JsonSerializer<CustomEMCEntry>,
    JsonDeserializer<CustomEMCEntry> {
        private Serializer() {
        }

        public CustomEMCEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = JsonUtils.func_151210_l((JsonElement)json, (String)"custom emc entry");
            if (!JsonUtils.func_151204_g((JsonObject)obj, (String)"item") || !JsonUtils.func_151204_g((JsonObject)obj, (String)"emc")) {
                throw new JsonParseException("Missing fields from Custom EMC entry");
            }
            String nss = JsonUtils.func_151206_a((JsonElement)obj.get("item"), (String)"item");
            int emc = JsonUtils.func_151215_f((JsonElement)obj.get("emc"), (String)"emc");
            if (emc < 0) {
                throw new JsonParseException("Invalid EMC amount: " + emc);
            }
            return new CustomEMCEntry(CustomConversionMapper.getNSSfromJsonString(nss, new HashMap<String, NormalizedSimpleStack>()), emc);
        }

        public JsonElement serialize(CustomEMCEntry src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.nss.json()));
            obj.add("emc", (JsonElement)new JsonPrimitive((Number)src.emc));
            return obj;
        }
    }

    public static class CustomEMCEntry {
        public final NormalizedSimpleStack nss;
        public final int emc;

        private CustomEMCEntry(NormalizedSimpleStack nss, int emc) {
            this.nss = nss;
            this.emc = emc;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CustomEMCEntry && this.nss.equals(((CustomEMCEntry)o).nss) && this.emc == ((CustomEMCEntry)o).emc;
        }

        public int hashCode() {
            return this.nss.hashCode() ^ 31 * this.emc;
        }
    }

    public static class CustomEMCFile {
        public final List<CustomEMCEntry> entries;

        public CustomEMCFile(List<CustomEMCEntry> entries) {
            this.entries = entries;
        }
    }
}

