/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class FuelMapper {
    private static final List<SimpleStack> FUEL_MAP = Lists.newArrayList();

    public static void loadMap() {
        if (!FUEL_MAP.isEmpty()) {
            FUEL_MAP.clear();
        }
        FuelMapper.addToMap(new ItemStack(Items.field_151044_h, 1, 1));
        FuelMapper.addToMap(new ItemStack(Items.field_151137_ax));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150451_bX));
        FuelMapper.addToMap(new ItemStack(Items.field_151044_h));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150402_ci));
        FuelMapper.addToMap(new ItemStack(Items.field_151016_H));
        FuelMapper.addToMap(new ItemStack(Items.field_151114_aO));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 0));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 0));
        FuelMapper.addToMap(new ItemStack(Items.field_151065_br));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150426_aN));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 1));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 1));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 2));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 2));
        Collections.sort(FUEL_MAP, Comparators.SIMPLESTACK_ASCENDING);
    }

    private static void addToMap(ItemStack stack) {
        if (EMCHelper.doesItemHaveEmc(stack)) {
            FuelMapper.addToMap(new SimpleStack(stack));
        }
    }

    public static boolean isStackFuel(ItemStack stack) {
        return FuelMapper.mapContains(new SimpleStack(stack));
    }

    public static boolean isStackMaxFuel(ItemStack stack) {
        return FuelMapper.indexInMap(new SimpleStack(stack)) == FUEL_MAP.size() - 1;
    }

    public static ItemStack getFuelUpgrade(ItemStack stack) {
        SimpleStack fuel = new SimpleStack(stack);
        int index = FuelMapper.indexInMap(fuel);
        if (index == -1) {
            PELogger.logFatal("Tried to upgrade invalid fuel: " + stack);
            return null;
        }
        int nextIndex = index == FUEL_MAP.size() - 1 ? 0 : index + 1;
        return FUEL_MAP.get(nextIndex).toItemStack();
    }

    private static void addToMap(SimpleStack stack) {
        if (stack.isValid()) {
            SimpleStack copy = stack.copy();
            copy.qnty = 1;
            if (!FUEL_MAP.contains(copy)) {
                FUEL_MAP.add(copy);
            }
        }
    }

    private static boolean mapContains(SimpleStack stack) {
        if (!stack.isValid()) {
            return false;
        }
        SimpleStack copy = stack.copy();
        copy.qnty = 1;
        return FUEL_MAP.contains(copy);
    }

    private static int indexInMap(SimpleStack stack) {
        SimpleStack copy = stack.copy();
        copy.qnty = 1;
        return FUEL_MAP.indexOf(copy);
    }
}

