/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;
import moze_intel.projecte.emc.collector.MappingCollector;
import moze_intel.projecte.emc.mappers.customConversions.json.CustomConversion;

public class WildcardSetValueFixCollector<V extends Comparable<V>, A extends IValueArithmetic>
extends AbstractMappingCollector<NormalizedSimpleStack, V, A> {
    IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner;
    Map<NormalizedSimpleStack.NSSItem, V> setValueBeforeMap = Maps.newHashMap();
    Map<NormalizedSimpleStack.NSSItem, V> setValueAfterMap = Maps.newHashMap();
    List<CustomConversion> setValueConversionList = Lists.newArrayList();

    public WildcardSetValueFixCollector(IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner) {
        super(inner.getArithmetic());
        this.inner = inner;
    }

    private boolean isWildCard(NormalizedSimpleStack nss) {
        return nss instanceof NormalizedSimpleStack.NSSItem && ((NormalizedSimpleStack.NSSItem)nss).damage == Short.MAX_VALUE;
    }

    @Override
    public void setValueBefore(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            this.setValueBeforeMap.put((NormalizedSimpleStack.NSSItem)something, value);
        } else {
            this.inner.setValueBefore(something, value);
        }
    }

    @Override
    public void setValueAfter(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            this.setValueAfterMap.put((NormalizedSimpleStack.NSSItem)something, value);
        } else {
            this.inner.setValueAfter(something, value);
        }
    }

    @Override
    public void setValueFromConversion(int outnumber, NormalizedSimpleStack something, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount) {
        if (this.isWildCard(something)) {
            this.setValueConversionList.add(CustomConversion.getFor(outnumber, something, ingredientsWithAmount));
        } else {
            this.inner.setValueFromConversion(outnumber, something, ingredientsWithAmount);
        }
    }

    @Override
    public void addConversion(int outnumber, NormalizedSimpleStack output, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        this.inner.addConversion(outnumber, output, ingredientsWithAmount, arithmeticForConversion);
    }

    @Override
    public void finishCollection() {
        for (Map.Entry<NormalizedSimpleStack.NSSItem, V> entry : this.setValueBeforeMap.entrySet()) {
            for (Integer meta : NormalizedSimpleStack.getUsedMetadata(entry.getKey())) {
                if (meta == Short.MAX_VALUE) continue;
                MappingCollector.debugFormat("Inserting Wildcard SetValueBefore %s:%d to %s", entry.getKey().itemName, meta, entry.getValue());
                this.inner.setValueBefore(NormalizedSimpleStack.getFor(entry.getKey().itemName, (int)meta), (Comparable)entry.getValue());
            }
        }
        for (Map.Entry<NormalizedSimpleStack.NSSItem, V> entry : this.setValueAfterMap.entrySet()) {
            for (Integer meta : NormalizedSimpleStack.getUsedMetadata(entry.getKey())) {
                if (meta == Short.MAX_VALUE) continue;
                this.inner.setValueAfter(NormalizedSimpleStack.getFor(entry.getKey().itemName, (int)meta), (Comparable)entry.getValue());
                MappingCollector.debugFormat("Inserting Wildcard SetValueAfter: %s:%d to %s", entry.getKey().itemName, meta, entry.getValue());
            }
        }
        for (CustomConversion conversion : this.setValueConversionList) {
            for (Integer meta : NormalizedSimpleStack.getUsedMetadata(conversion.output)) {
                if (meta == Short.MAX_VALUE) continue;
                MappingCollector.debugFormat("Inserting Wildcard SetValueFromConversion %s:%d to %s", conversion.output, meta, conversion);
                this.inner.setValueFromConversion(conversion.count, NormalizedSimpleStack.getFor(conversion.output, (int)meta), this.ingredientMapFromStringMap(conversion.ingredients));
            }
        }
        this.inner.finishCollection();
    }

    private Map<NormalizedSimpleStack, Integer> ingredientMapFromStringMap(Map<String, Integer> map) {
        HashMap out = Maps.newHashMap();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            out.put(NormalizedSimpleStack.fromSerializedItem(entry.getKey()), entry.getValue());
        }
        return out;
    }
}

