/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.NormalizedSimpleStack;
import moze_intel.projecte.emc.arithmetics.FullFractionArithmetic;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidMapper
implements IEMCMapper<NormalizedSimpleStack, Integer> {
    private static final List<Pair<NormalizedSimpleStack, FluidStack>> melting = Lists.newArrayList();

    private static void addMelting(String odName, String fluidName, int amount) {
        FluidMapper.addMelting(NormalizedSimpleStack.forOreDictionary(odName), fluidName, amount);
    }

    private static void addMelting(Item item, String fluidName, int amount) {
        FluidMapper.addMelting(NormalizedSimpleStack.getFor(item), fluidName, amount);
    }

    private static void addMelting(Block block, String fluidName, int amount) {
        FluidMapper.addMelting(NormalizedSimpleStack.getFor(block), fluidName, amount);
    }

    private static void addMelting(NormalizedSimpleStack stack, String fluidName, int amount) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null) {
            melting.add((Pair<NormalizedSimpleStack, FluidStack>)Pair.of((Object)stack, (Object)new FluidStack(fluid, amount)));
        } else {
            PELogger.logWarn("Can not get Fluid '%s'", fluidName);
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Integer> mapper, Configuration config) {
        mapper.setValueBefore(NormalizedSimpleStack.getFor(FluidRegistry.WATER), Integer.MIN_VALUE);
        mapper.addConversion(1000, NormalizedSimpleStack.getFor(FluidRegistry.LAVA), Arrays.asList(NormalizedSimpleStack.getFor(Blocks.field_150343_Z)));
        NormalizedSimpleStack fakeMilkFluid = NormalizedSimpleStack.createFake("fakeMilkFluid");
        mapper.setValueBefore(fakeMilkFluid, 16);
        mapper.addConversion(1, NormalizedSimpleStack.getFor(Items.field_151117_aB), Arrays.asList(NormalizedSimpleStack.getFor(Items.field_151133_ar), fakeMilkFluid));
        Fluid milkFluid = FluidRegistry.getFluid((String)"milk");
        if (milkFluid != null) {
            mapper.addConversion(1000, NormalizedSimpleStack.getFor(milkFluid), Arrays.asList(fakeMilkFluid));
        }
        if (!(mapper instanceof IExtendedMappingCollector)) {
            throw new RuntimeException("Cannot add Extended Fluid Mappings to mapper!");
        }
        IExtendedMappingCollector emapper = (IExtendedMappingCollector)mapper;
        FullFractionArithmetic fluidArithmetic = new FullFractionArithmetic();
        for (Pair<NormalizedSimpleStack, FluidStack> pair : melting) {
            emapper.addConversion(((FluidStack)pair.getValue()).amount, NormalizedSimpleStack.getFor(((FluidStack)pair.getValue()).getFluid()), Arrays.asList((NormalizedSimpleStack)pair.getKey()), fluidArithmetic);
        }
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            Fluid fluid = data.fluid.getFluid();
            mapper.addConversion(1, NormalizedSimpleStack.getFor(data.filledContainer), (Map<NormalizedSimpleStack, Integer>)ImmutableMap.of((Object)NormalizedSimpleStack.getFor(data.emptyContainer), (Object)1, (Object)NormalizedSimpleStack.getFor(fluid), (Object)data.fluid.amount));
        }
    }

    @Override
    public String getName() {
        return "FluidMapper";
    }

    @Override
    public String getDescription() {
        return "Adds Conversions for fluid container items and fluids.";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    static {
        FluidMapper.addMelting(Blocks.field_150343_Z, "obisidan.molten", 288);
        FluidMapper.addMelting(Blocks.field_150359_w, "glass.molten", 1000);
        FluidMapper.addMelting(Blocks.field_150410_aZ, "glass.molten", 250);
        FluidMapper.addMelting(Items.field_151079_bi, "ender", 250);
        FluidMapper.addMelting("ingotIron", "iron.molten", 144);
        FluidMapper.addMelting("ingotGold", "gold.molten", 144);
        FluidMapper.addMelting("ingotCopper", "copper.molten", 144);
        FluidMapper.addMelting("ingotTin", "tin.molten", 144);
        FluidMapper.addMelting("ingotSilver", "silver.molten", 144);
        FluidMapper.addMelting("ingotLead", "lead.molten", 144);
        FluidMapper.addMelting("ingotNickel", "nickel.molten", 144);
        FluidMapper.addMelting("ingotAluminum", "aluminum.molten", 144);
        FluidMapper.addMelting("ingotArdite", "ardite.molten", 144);
        FluidMapper.addMelting("ingotCobalt", "cobalt.molten", 144);
        FluidMapper.addMelting("ingotPlatinum", "platinum.molten", 144);
        FluidMapper.addMelting("ingotObsidian", "obsidian.molten", 144);
        FluidMapper.addMelting("ingotElectrum", "electrum.molten", 144);
        FluidMapper.addMelting("ingotInvar", "invar.molten", 144);
        FluidMapper.addMelting("ingotSignalum", "signalum.molten", 144);
        FluidMapper.addMelting("ingotLumium", "lumium.molten", 144);
        FluidMapper.addMelting("ingotEnderium", "enderium.molten", 144);
        FluidMapper.addMelting("ingotMithril", "mithril.molten", 144);
        FluidMapper.addMelting("ingotBronze", "bronze.molten", 144);
        FluidMapper.addMelting("ingotAluminumBrass", "aluminumbrass.molten", 144);
        FluidMapper.addMelting("ingotManyullyn", "manyullyn.molten", 144);
        FluidMapper.addMelting("ingotAlumite", "alumite.molten", 144);
        FluidMapper.addMelting("gemEmerald", "emerald.liquid", 640);
        FluidMapper.addMelting("dustRedstone", "redstone", 100);
        FluidMapper.addMelting("dustGlowstone", "glowstone", 250);
        FluidMapper.addMelting("dustCryotheum", "cryotheum", 100);
        FluidMapper.addMelting("dustPryotheum", "pryotheum", 100);
    }
}

