/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.UpdateGemModePKT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class EternalDensityInventory
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable inventory = new ItemStackHandler(9){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }
    };
    private boolean isInWhitelist;
    public final ItemStack invItem;

    public EternalDensityInventory(ItemStack stack, EntityPlayer player) {
        this.invItem = stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(stack.func_77978_p());
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack ret = this.inventory.insertItem(slot, stack, simulate);
        this.writeBack();
        return ret;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack ret = this.inventory.extractItem(slot, amount, simulate);
        this.writeBack();
        return ret;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
        this.writeBack();
    }

    private void writeBack() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i) == null || this.inventory.getStackInSlot((int)i).field_77994_a != 0) continue;
            this.inventory.setStackInSlot(i, null);
        }
        this.writeToNBT(this.invItem.func_77978_p());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.isInWhitelist = nbt.func_74767_n("Whitelist");
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inventory, null, (NBTBase)nbt.func_150295_c("Items", 10));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("Whitelist", this.isInWhitelist);
        nbt.func_74782_a("Items", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inventory, null));
    }

    public void changeMode() {
        this.isInWhitelist = !this.isInWhitelist;
        this.writeBack();
        PacketHandler.sendToServer(new UpdateGemModePKT(this.isInWhitelist));
    }

    public boolean isWhitelistMode() {
        return this.isInWhitelist;
    }

    public int findFirstEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i) != null) continue;
            return i;
        }
        return -1;
    }
}

