/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.manual.AbstractPage;
import moze_intel.projecte.manual.ImagePage;
import moze_intel.projecte.manual.IndexPage;
import moze_intel.projecte.manual.ItemPage;
import moze_intel.projecte.manual.ManualFontRenderer;
import moze_intel.projecte.manual.ManualPageHandler;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIManual
extends GuiScreen {
    public static final int WINDOW_WIDTH = 256;
    public static final int TEXT_WIDTH = 145;
    public static final int PAGE_HEIGHT = 226;
    public static final int TEXT_HEIGHT = 163;
    public static final int TEXT_Y_OFFSET = 10;
    public static final float GUI_SCALE_FACTOR = 1.5f;
    public static final int BUTTON_HEIGHT = 13;
    private static final int CHARACTER_HEIGHT = 9;
    private static final int BUTTON_ID_OFFSET = 3;
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("projecte:textures/gui/bookTexture.png");
    private static final ManualFontRenderer peFontRenderer = new ManualFontRenderer();
    public static final int ENTRIES_PER_PAGE = 16;
    public static final Multimap<IndexPage, IndexLinkButton> indexLinks = ArrayListMultimap.create();
    private static final ResourceLocation bookGui = new ResourceLocation("textures/gui/book.png");
    public List<String> bodyTexts = Lists.newArrayList();
    private int currentSpread;
    private int k;

    public void drawItemStackToGui(ItemStack item, int x, int y) {
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        this.field_146296_j.func_180450_b(item, x, y);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    public static List<String> splitBody(String s) {
        return peFontRenderer.func_78271_c(s, 145);
    }

    public void func_73866_w_() {
        GL11.glScalef((float)1.5f, (float)1.0f, (float)1.5f);
        this.k = (Math.round((float)this.field_146294_l / 1.5f) - 256) / 2;
        GL11.glScalef((float)0.6666667f, (float)1.0f, (float)0.6666667f);
        this.field_146292_n.add(new PageTurnButton(0, Math.round((float)(this.k + 256 - 40) * 1.5f), 226 - Math.round(18.199999f), true));
        this.field_146292_n.add(new PageTurnButton(1, Math.round((float)(this.k + 20) * 1.5f), 226 - Math.round(18.199999f), false));
        String text = I18n.func_135052_a((String)"pe.manual.index_button", (Object[])new Object[0]);
        int stringWidth = this.field_146297_k.field_71466_p.func_78256_a(text);
        this.field_146292_n.add(new TocButton(2, this.field_146294_l / 2 - stringWidth / 2, 226 - Math.round(16.9f), stringWidth, 15, text));
        this.addIndexButtons(Math.round((float)(this.k + 20) * 1.5f));
        this.currentSpread = 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BOOK_TEXTURE);
        GlStateManager.func_179152_a((float)1.5f, (float)1.0f, (float)1.5f);
        this.func_73729_b(this.k, 5, 0, 0, 256, 226);
        GlStateManager.func_179152_a((float)0.6666667f, (float)1.0f, (float)0.6666667f);
        AbstractPage currentPage = (AbstractPage)ManualPageHandler.spreads.get(this.currentSpread).getLeft();
        AbstractPage nextPage = (AbstractPage)ManualPageHandler.spreads.get(this.currentSpread).getRight();
        if (currentPage != null) {
            this.drawPage(currentPage, this.k + 40, this.k + 20);
        }
        if (nextPage != null) {
            this.drawPage(nextPage, this.k + 160, this.k + 140);
        }
        this.updateButtons();
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                ++this.currentSpread;
                break;
            }
            case 1: {
                --this.currentSpread;
                break;
            }
            case 2: {
                this.currentSpread = 0;
                break;
            }
            default: {
                int val = Math.round((float)(button.field_146127_k - 3) / 2.0f);
                PELogger.logDebug("Clicked button %d which is supposed to be page %d, taking you to spread %d which has page %d on the left", button.field_146127_k, button.field_146127_k - 3, val, ManualPageHandler.pages.indexOf(ManualPageHandler.spreads.get(val).getLeft()));
                this.currentSpread = val;
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.isViewingIndex()) {
            ((PageTurnButton)((Object)this.field_146292_n.get((int)0))).field_146125_m = true;
            ((PageTurnButton)((Object)this.field_146292_n.get((int)1))).field_146125_m = this.currentSpread != 0;
            ((TocButton)((Object)this.field_146292_n.get((int)2))).field_146125_m = false;
            for (int i = 3; i < this.field_146292_n.size(); ++i) {
                Pair<AbstractPage, AbstractPage> spread = ManualPageHandler.spreads.get(this.currentSpread);
                ((IndexLinkButton)((Object)this.field_146292_n.get((int)i))).field_146125_m = indexLinks.get((Object)((IndexPage)spread.getLeft())).contains(this.field_146292_n.get(i)) || spread.getRight() != null && indexLinks.get((Object)((IndexPage)spread.getRight())).contains(this.field_146292_n.get(i));
            }
        } else if (this.currentSpread == ManualPageHandler.spreads.size() - 1) {
            ((PageTurnButton)((Object)this.field_146292_n.get((int)0))).field_146125_m = false;
            ((PageTurnButton)((Object)this.field_146292_n.get((int)1))).field_146125_m = true;
            ((TocButton)((Object)this.field_146292_n.get((int)2))).field_146125_m = true;
            for (int i = 3; i < this.field_146292_n.size(); ++i) {
                ((IndexLinkButton)((Object)this.field_146292_n.get((int)i))).field_146125_m = false;
            }
        } else {
            ((PageTurnButton)((Object)this.field_146292_n.get((int)0))).field_146125_m = true;
            ((PageTurnButton)((Object)this.field_146292_n.get((int)1))).field_146125_m = true;
            ((TocButton)((Object)this.field_146292_n.get((int)2))).field_146125_m = true;
            for (int i = 3; i < this.field_146292_n.size(); ++i) {
                ((IndexLinkButton)((Object)this.field_146292_n.get((int)i))).field_146125_m = false;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawImage(ResourceLocation resource, int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resource);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        this.func_73729_b(x, y, 0, 0, 256, 256);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private void addIndexButtons(int x) {
        int yOffset = 42;
        Iterator<IndexPage> iter = ManualPageHandler.indexPages.iterator();
        IndexPage addingTo = iter.next();
        int entriesOnCurrentPage = 0;
        for (AbstractPage page : ManualPageHandler.pages) {
            if (!page.shouldAppearInIndex()) continue;
            if (entriesOnCurrentPage == 16) {
                entriesOnCurrentPage = 0;
                addingTo = iter.next();
                x = ManualPageHandler.indexPages.indexOf(addingTo) % 2 == 0 ? (x -= 175) : (x += 175);
                yOffset = 42;
            }
            String text = page.getHeaderText();
            int buttonID = ManualPageHandler.pages.indexOf(page) + 3;
            IndexLinkButton button = new IndexLinkButton(buttonID, x, yOffset, this.field_146297_k.field_71466_p.func_78256_a(text), 9, text);
            this.field_146292_n.add(button);
            indexLinks.put((Object)addingTo, (Object)button);
            ++entriesOnCurrentPage;
            yOffset += 10;
        }
    }

    private boolean isViewingIndex() {
        return ManualPageHandler.spreads.get(this.currentSpread).getLeft() instanceof IndexPage;
    }

    public void drawPage(AbstractPage page, int headerX, int contentX) {
        this.field_146289_q.func_175065_a(page.getHeaderText(), (float)Math.round((float)headerX * 1.5f), 27.0f, 0, false);
        if (!(page instanceof IndexPage)) {
            if (page instanceof ImagePage) {
                this.drawImage(((ImagePage)page).getImageLocation(), Math.round((float)contentX * 1.5f * 2.0f), 80);
            } else {
                this.bodyTexts = GUIManual.splitBody(page.getBodyText());
                for (int i = 0; i < this.bodyTexts.size() && (double)i < Math.floor(16.0); ++i) {
                    this.field_146289_q.func_78276_b(this.bodyTexts.get(i).charAt(0) == ' ' ? this.bodyTexts.get(i).substring(1) : this.bodyTexts.get(i), Math.round((float)contentX * 1.5f), 43 + 10 * i, Color.black.getRGB());
                }
                if (page instanceof ItemPage) {
                    ItemPage itemPage = (ItemPage)page;
                    this.drawItemStackToGui(itemPage.getItemStack(), Math.round((float)contentX * 1.5f), 22);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class PageTurnButton
    extends GuiButton {
        private static final int bWidth = 23;
        private final boolean pointsRight;

        public PageTurnButton(int ID, int xPos, int yPos, boolean par4) {
            super(ID, xPos, yPos, 23, 13, "");
            this.pointsRight = par4;
        }

        public void func_146112_a(@Nonnull Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean hover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookGui);
                int u = 0;
                int v = 192;
                if (hover) {
                    u += 23;
                }
                if (!this.pointsRight) {
                    v += 13;
                }
                GlStateManager.func_179147_l();
                this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, 23, 13);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class IndexLinkButton
    extends GuiButton {
        public IndexLinkButton(int par1, int par2, int par3, int par4, int par5, String par6) {
            super(par1, par2, par3, par4, par5, par6);
        }

        public void func_146112_a(@Nonnull Minecraft mc, int par2, int par3) {
            if (this.field_146125_m) {
                GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
                mc.field_71466_p.func_78276_b(this.field_146126_j, this.field_146128_h, this.field_146129_i, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class TocButton
    extends GuiButton {
        public TocButton(int ID, int xPos, int yPos, int bWidth, int bHeight, String text) {
            super(ID, xPos, yPos, bWidth, bHeight, text);
        }
    }
}

