/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.items.DiviningRodHigh;
import moze_intel.projecte.gameObjs.items.DiviningRodMedium;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DiviningRodLow
extends ItemPE
implements IModeChanger {
    protected final String[] modes;

    public DiviningRodLow() {
        this.func_77655_b("divining_rod_1");
        this.modes = new String[]{"3x3x3"};
    }

    protected DiviningRodLow(String[] modeDesc) {
        this.modes = modeDesc;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK)) {
            PlayerHelper.swingItem(player, hand);
            ArrayList emcValues = Lists.newArrayList();
            long totalEmc = 0L;
            int numBlocks = 0;
            byte mode = this.getMode(stack);
            int depth = this.getDepthFromMode(mode);
            AxisAlignedBB box = WorldHelper.getDeepBox(mop.func_178782_a(), mop.field_178784_b, depth);
            for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
                List drops;
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (world.func_175623_d(pos) || (drops = block.getDrops((IBlockAccess)world, pos, state, 0)).size() == 0) continue;
                ItemStack blockStack = (ItemStack)drops.get(0);
                int blockEmc = EMCHelper.getEmcValue(blockStack);
                if (blockEmc == 0) {
                    Map map = FurnaceRecipes.func_77602_a().func_77599_b();
                    for (Map.Entry entry : map.entrySet()) {
                        int currentValue;
                        if (entry == null || entry.getKey() == null || !ItemHelper.areItemStacksEqualIgnoreNBT((ItemStack)entry.getKey(), blockStack) || (currentValue = EMCHelper.getEmcValue((ItemStack)entry.getValue())) == 0) continue;
                        if (!emcValues.contains(currentValue)) {
                            emcValues.add(currentValue);
                        }
                        totalEmc += (long)currentValue;
                    }
                } else {
                    if (!emcValues.contains(blockEmc)) {
                        emcValues.add(blockEmc);
                    }
                    totalEmc += (long)blockEmc;
                }
                ++numBlocks;
            }
            if (numBlocks == 0) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            int[] maxValues = new int[3];
            for (int i = 0; i < 3; ++i) {
                maxValues[i] = 1;
            }
            Collections.sort(emcValues, Comparators.INT_DESCENDING);
            int num = emcValues.size() >= 3 ? 3 : emcValues.size();
            for (int i = 0; i < num; ++i) {
                maxValues[i] = (Integer)emcValues.get(i);
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("pe.divining.avgemc", new Object[]{numBlocks, totalEmc / (long)numBlocks}));
            if (this instanceof DiviningRodMedium) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("pe.divining.maxemc", new Object[]{maxValues[0]}));
            }
            if (this instanceof DiviningRodHigh) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("pe.divining.secondmax", new Object[]{maxValues[1]}));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("pe.divining.thirdmax", new Object[]{maxValues[2]}));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private int getDepthFromMode(byte mode) {
        String modeDesc = this.modes[mode];
        return Integer.parseInt(modeDesc.substring(0, modeDesc.indexOf(120))) - 1;
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        return stack.func_77978_p().func_74771_c("Mode");
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        if (this.modes.length == 1) {
            return false;
        }
        if (this.getMode(stack) == this.modes.length - 1) {
            stack.func_77978_p().func_74774_a("Mode", (byte)0);
        } else {
            stack.func_77978_p().func_74774_a("Mode", (byte)(this.getMode(stack) + 1));
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("pe.item.mode_switch", new Object[]{this.modes[this.getMode(stack)]}));
        return true;
    }
}

