/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.api.item.IAlchChestItem;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PELogger;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class GemEternalDensity
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IModeChanger,
IBauble {
    public GemEternalDensity() {
        this.func_77655_b("gem_density");
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        GemEternalDensity.condense(stack, (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP));
    }

    private static boolean condense(ItemStack gem, IItemHandler inv) {
        if (gem.func_77952_i() == 0 || ItemPE.getEmc(gem) >= 1.073741824E9) {
            return false;
        }
        boolean hasChanged = false;
        boolean isWhitelist = GemEternalDensity.isWhitelistMode(gem);
        List<ItemStack> whitelist = GemEternalDensity.getWhitelist(gem);
        ItemStack target = GemEternalDensity.getTarget(gem);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack s = inv.getStackInSlot(i);
            if (s == null || !EMCHelper.doesItemHaveEmc(s) || s.func_77976_d() == 1 || EMCHelper.getEmcValue(s) >= EMCHelper.getEmcValue(target) || inv.extractItem(i, s.field_77994_a == 1 ? 1 : s.field_77994_a / 2, true) == null || (!isWhitelist || !GemEternalDensity.listContains(whitelist, s)) && (isWhitelist || GemEternalDensity.listContains(whitelist, s))) continue;
            ItemStack copy = inv.extractItem(i, s.field_77994_a == 1 ? 1 : s.field_77994_a / 2, false);
            GemEternalDensity.addToList(gem, copy);
            ItemPE.addEmcToStack(gem, EMCHelper.getEmcValue(copy) * copy.field_77994_a);
            hasChanged = true;
            break;
        }
        int value = EMCHelper.getEmcValue(target);
        if (!EMCHelper.doesItemHaveEmc(target)) {
            return hasChanged;
        }
        while (GemEternalDensity.getEmc(gem) >= (double)value) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)ItemStack.func_77944_b((ItemStack)target), (boolean)false);
            if (remain != null) {
                return false;
            }
            ItemPE.removeEmc(gem, value);
            GemEternalDensity.setItems(gem, Lists.newArrayList());
            hasChanged = true;
        }
        return hasChanged;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                if (stack.func_77952_i() == 1) {
                    List<ItemStack> items = GemEternalDensity.getItems(stack);
                    if (!items.isEmpty()) {
                        WorldHelper.createLootDrop(items, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        GemEternalDensity.setItems(stack, new ArrayList<ItemStack>());
                        ItemPE.setEmc(stack, 0.0);
                    }
                    stack.func_77964_b(0);
                } else {
                    stack.func_77964_b(1);
                }
            } else {
                player.openGui((Object)PECore.instance, 15, world, hand == EnumHand.MAIN_HAND ? 0 : 1, -1, -1);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private String getTargetName(ItemStack stack) {
        switch (stack.func_77978_p().func_74771_c("Target")) {
            case 0: {
                return "item.ingotIron.name";
            }
            case 1: {
                return "item.ingotGold.name";
            }
            case 2: {
                return "item.diamond.name";
            }
            case 3: {
                return "item.pe_matter_dark.name";
            }
            case 4: {
                return "item.pe_matter_red.name";
            }
        }
        return "INVALID";
    }

    private static ItemStack getTarget(ItemStack stack) {
        switch (stack.func_77978_p().func_74771_c("Target")) {
            case 0: {
                return new ItemStack(Items.field_151042_j);
            }
            case 1: {
                return new ItemStack(Items.field_151043_k);
            }
            case 2: {
                return new ItemStack(Items.field_151045_i);
            }
            case 3: {
                return new ItemStack(ObjHandler.matter, 1, 0);
            }
            case 4: {
                return new ItemStack(ObjHandler.matter, 1, 1);
            }
        }
        PELogger.logFatal("Invalid target for gem of eternal density: " + stack.func_77978_p().func_74771_c("Target"));
        return null;
    }

    private static void setItems(ItemStack stack, List<ItemStack> list) {
        NBTTagList tList = new NBTTagList();
        for (ItemStack s : list) {
            NBTTagCompound nbt = new NBTTagCompound();
            s.func_77955_b(nbt);
            tList.func_74742_a((NBTBase)nbt);
        }
        stack.func_77978_p().func_74782_a("Consumed", (NBTBase)tList);
    }

    private static List<ItemStack> getItems(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        NBTTagList tList = stack.func_77978_p().func_150295_c("Consumed", 10);
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            list.add(ItemStack.func_77949_a((NBTTagCompound)tList.func_150305_b(i)));
        }
        return list;
    }

    private static void addToList(ItemStack gem, ItemStack stack) {
        List<ItemStack> list = GemEternalDensity.getItems(gem);
        GemEternalDensity.addToList(list, stack);
        GemEternalDensity.setItems(gem, list);
    }

    private static void addToList(List<ItemStack> list, ItemStack stack) {
        boolean hasFound = false;
        for (ItemStack s : list) {
            if (s.field_77994_a >= s.func_77976_d() || !ItemHelper.areItemStacksEqual(s, stack)) continue;
            int remain = s.func_77976_d() - s.field_77994_a;
            if (stack.field_77994_a <= remain) {
                s.field_77994_a += stack.field_77994_a;
                hasFound = true;
                break;
            }
            s.field_77994_a += remain;
            stack.field_77994_a -= remain;
        }
        if (!hasFound) {
            list.add(stack);
        }
    }

    private static boolean isWhitelistMode(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("Whitelist");
    }

    private static List<ItemStack> getWhitelist(ItemStack stack) {
        ArrayList result = Lists.newArrayList();
        NBTTagList list = stack.func_77978_p().func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            result.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
        }
        return result;
    }

    private static boolean listContains(List<ItemStack> list, ItemStack stack) {
        for (ItemStack s : list) {
            if (!ItemHelper.areItemStacksEqual(s, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74771_c("Target");
        }
        return 0;
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        byte oldMode = this.getMode(stack);
        if (oldMode == 4) {
            stack.func_77978_p().func_74774_a("Target", (byte)0);
        } else {
            stack.func_77978_p().func_74774_a("Target", (byte)(oldMode + 1));
        }
        player.func_146105_b(new TextComponentTranslation("pe.gemdensity.mode_switch", new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(this.getTargetName(stack), new Object[0])));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        list.add(I18n.func_135052_a((String)"pe.gemdensity.tooltip1", (Object[])new Object[0]));
        if (stack.func_77942_o()) {
            list.add(I18n.func_135052_a((String)"pe.gemdensity.tooltip2", (Object[])new Object[]{I18n.func_135052_a((String)this.getTargetName(stack), (Object[])new Object[0])}));
        }
        list.add(I18n.func_135052_a((String)"pe.gemdensity.tooltip3", (Object[])new Object[]{ClientKeyHelper.getKeyName(PEKeybind.MODE)}));
        list.add(I18n.func_135052_a((String)"pe.gemdensity.tooltip4", (Object[])new Object[0]));
        list.add(I18n.func_135052_a((String)"pe.gemdensity.tooltip5", (Object[])new Object[0]));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInAlchChest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        if (!world.field_72995_K && stack.func_77952_i() == 1) {
            AlchChestTile tile = (AlchChestTile)world.func_175625_s(pos);
            GemEternalDensity.condense(stack, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            tile.func_70296_d();
        }
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        return !player.field_70170_p.field_72995_K && GemEternalDensity.condense(stack, inv);
    }
}

