/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.api.state.enums.EnumMatterType;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.tools.PEToolBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class DarkHammer
extends PEToolBase {
    public DarkHammer() {
        super("dm_hammer", (byte)2, new String[0]);
        this.setNoRepair();
        this.peToolMaterial = "dm_tools";
        this.harvestMaterials.add(Material.field_151573_f);
        this.harvestMaterials.add(Material.field_151574_g);
        this.harvestMaterials.add(Material.field_151576_e);
        this.toolClasses.add("hammer");
        this.toolClasses.add("pickaxe");
        this.toolClasses.add("chisel");
    }

    protected DarkHammer(String name, byte numCharges, String[] modeDesc) {
        super(name, numCharges, modeDesc);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager) {
        boolean flag = ProjectEConfig.useOldDamage;
        this.attackWithCharge(stack, damaged, damager, flag ? 13.0f : 1.0f);
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        this.digAOE(stack, world, player, true, 0, hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == ObjHandler.matterBlock && state.func_177229_b(PEStateProps.TIER_PROP) == EnumMatterType.DARK_MATTER || block == ObjHandler.dmFurnaceOff || block == ObjHandler.dmFurnaceOn) {
            return 1200000.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        byte charge = stack.func_77978_p() == null ? (byte)0 : this.getCharge(stack);
        float damage = 13.0f + (float)charge;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (!ProjectEConfig.useOldDamage) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, 0));
        }
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -3.0, 0));
        return multimap;
    }
}

