/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.api.state.enums.EnumMatterType;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.tools.PEToolBase;
import moze_intel.projecte.gameObjs.items.tools.RedPick;
import moze_intel.projecte.utils.AchievementHandler;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DarkPick
extends PEToolBase {
    public DarkPick() {
        super("dm_pick", (byte)2, new String[]{"pe.darkpick.mode1", "pe.darkpick.mode2", "pe.darkpick.mode3", "pe.darkpick.mode4"});
        this.setNoRepair();
        this.peToolMaterial = "dm_tools";
        this.toolClasses.add("pickaxe");
        this.harvestMaterials.add(Material.field_151573_f);
        this.harvestMaterials.add(Material.field_151574_g);
        this.harvestMaterials.add(Material.field_151576_e);
    }

    protected DarkPick(String name, byte numCharges, String[] modeDesc) {
        super(name, numCharges, modeDesc);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (ProjectEConfig.pickaxeAoeVeinMining) {
            this.mineOreVeinsInAOE(stack, player, hand);
        } else {
            RayTraceResult mop = this.func_77621_a(world, player, false);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && ItemHelper.isOre(world.func_180495_p(mop.func_178782_a()))) {
                this.tryVeinMine(stack, player, mop);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase eLiving) {
        this.digBasedOnMode(stack, world, state.func_177230_c(), pos, eLiving);
        return true;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == ObjHandler.matterBlock && state.func_177229_b(PEStateProps.TIER_PROP) == EnumMatterType.DARK_MATTER || block == ObjHandler.dmFurnaceOff || block == ObjHandler.dmFurnaceOn) {
            return 1200000.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        if (!world.field_72995_K) {
            player.func_71064_a((StatBase)AchievementHandler.DM_PICK, 1);
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this instanceof RedPick ? 8.0 : 7.0, 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.8, 0));
        return multimap;
    }
}

