/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CondenserMK2Tile
extends CondenserTile {
    private final IItemHandlerModifiable automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.getInput(), WrappedItemHandler.WriteMode.IN){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return SlotPredicates.HAS_EMC.test(stack) && !CondenserMK2Tile.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandlerModifiable automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.getOutput(), WrappedItemHandler.WriteMode.OUT);
    private final CombinedInvWrapper joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationOutput});

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nonnull EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.joined);
            }
            if (side == EnumFacing.DOWN) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationOutput);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInput);
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected ItemStackHandler createInput() {
        return new TileEmc.StackHandler(this, 42);
    }

    @Override
    protected ItemStackHandler createOutput() {
        return new TileEmc.StackHandler(this, 42);
    }

    @Override
    protected void condense() {
        while (this.hasSpace() && this.getStoredEmc() >= (double)this.requiredEmc) {
            this.pushStack();
            this.removeEMC(this.requiredEmc);
        }
        if (this.hasSpace()) {
            for (int i = 0; i < this.getInput().getSlots(); ++i) {
                ItemStack stack = this.getInput().getStackInSlot(i);
                if (stack == null) continue;
                this.addEMC(EMCHelper.getEmcValue(stack) * stack.field_77994_a);
                this.getInput().setStackInSlot(i, null);
                break;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getOutput().deserializeNBT(nbt.func_74775_l("Output"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("Output", (NBTBase)this.getOutput().serializeNBT());
        return nbt;
    }
}

