/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class RMFurnaceTile
extends TileEmc
implements IEmcAcceptor {
    private static final float EMC_CONSUMPTION = 1.6f;
    private final ItemStackHandler inputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler outputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler fuelInv = new TileEmc.StackHandler(this, 1);
    private final IItemHandlerModifiable automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return SlotPredicates.SMELTABLE.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandlerModifiable automationFuel = new WrappedItemHandler((IItemHandlerModifiable)this.fuelInv, WrappedItemHandler.WriteMode.IN){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return SlotPredicates.FURNACE_FUEL.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandlerModifiable automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.outputInventory, WrappedItemHandler.WriteMode.OUT);
    private final CombinedInvWrapper joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationFuel, this.automationOutput});
    protected final int ticksBeforeSmelt;
    private final int efficiencyBonus;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public RMFurnaceTile() {
        this(3, 4);
    }

    protected RMFurnaceTile(int ticksBeforeSmelt, int efficiencyBonus) {
        super(64);
        this.ticksBeforeSmelt = ticksBeforeSmelt;
        this.efficiencyBonus = efficiencyBonus;
    }

    protected int getInvSize() {
        return 13;
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    private ItemStack getFuelItem() {
        return this.fuelInv.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInventory;
    }

    public IItemHandler getOutput() {
        return this.outputInventory;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nonnull EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nonnull EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.joined);
            }
            if (side == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInput);
            }
            if (side == EnumFacing.DOWN) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationOutput);
            }
            if (side.func_176740_k().func_176722_c()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationFuel);
            }
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_73660_a() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            IItemEmc itemEmc;
            this.pullFromInventories();
            ItemHelper.compactInventory((IItemHandlerModifiable)this.inputInventory);
            if (this.canSmelt() && this.getFuelItem() != null && this.getFuelItem().func_77973_b() instanceof IItemEmc && (itemEmc = (IItemEmc)this.getFuelItem().func_77973_b()).getStoredEmc(this.getFuelItem()) >= (double)1.6f) {
                itemEmc.extractEmc(this.getFuelItem(), 1.6f);
                this.addEMC(1.6f);
            }
            if (this.getStoredEmc() >= (double)1.6f) {
                this.furnaceBurnTime = 1;
                this.removeEMC(1.6f);
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.getFuelItem());
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.getFuelItem() != null) {
                        --this.getFuelItem().field_77994_a;
                        if (this.getFuelItem().field_77994_a == 0) {
                            this.fuelInv.setStackInSlot(0, this.getFuelItem().func_77973_b().getContainerItem(this.getFuelItem()));
                        }
                    }
                }
            }
            if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.ticksBeforeSmelt) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
                if (!this.field_145850_b.field_72995_K && block instanceof MatterFurnace) {
                    ((MatterFurnace)block).updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.func_174877_v());
                }
            }
            if (flag1) {
                this.func_70296_d();
            }
            ItemHelper.compactInventory((IItemHandlerModifiable)this.outputInventory);
            this.pushToInventories();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private void pullFromInventories() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (tile == null || tile instanceof TileEntityHopper || tile instanceof TileEntityDropper) {
            return;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (handler == null) {
            if (tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, EnumFacing.DOWN);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            } else {
                return;
            }
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStackHandler targetInv;
            ItemStack remainderTest;
            int successfullyTransferred;
            ItemStack extractTest = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest == null || (successfullyTransferred = extractTest.field_77994_a - ((remainderTest = ItemHandlerHelper.insertItemStacked((IItemHandler)(targetInv = extractTest.func_77973_b() instanceof IItemEmc || TileEntityFurnace.func_145954_b((ItemStack)extractTest) ? this.fuelInv : this.inputInventory), (ItemStack)extractTest, (boolean)true)) == null ? 0 : remainderTest.field_77994_a)) <= 0) continue;
            ItemStack toInsert = handler.extractItem(i, successfullyTransferred, false);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)toInsert, (boolean)false);
            assert (result == null);
        }
    }

    private void pushToInventories() {
    }

    private void smeltItem() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt).func_77946_l();
        if (ItemHelper.getOreDictionaryName(toSmelt).startsWith("ore")) {
            smeltResult.field_77994_a *= 2;
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)smeltResult, (boolean)false);
        --toSmelt.field_77994_a;
        if (toSmelt.field_77994_a == 0) {
            this.inputInventory.setStackInSlot(0, null);
        }
    }

    private boolean canSmelt() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        if (toSmelt == null) {
            return false;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt);
        if (smeltResult == null) {
            return false;
        }
        ItemStack currentSmelted = this.outputInventory.getStackInSlot(this.outputInventory.getSlots() - 1);
        if (currentSmelted == null) {
            return true;
        }
        if (!smeltResult.func_77969_a(currentSmelted)) {
            return false;
        }
        int result = currentSmelted.field_77994_a + smeltResult.field_77994_a;
        return result <= currentSmelted.func_77976_d();
    }

    private int getItemBurnTime(ItemStack stack) {
        int val = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return val * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    public int getCookProgressScaled(int value) {
        return (this.furnaceCookTime + (this.isBurning() && this.canSmelt() ? 1 : 0)) * value / this.ticksBeforeSmelt;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int value) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.ticksBeforeSmelt;
        }
        return this.furnaceBurnTime * value / this.currentItemBurnTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.outputInventory.deserializeNBT(nbt.func_74775_l("Output"));
        this.fuelInv.deserializeNBT(nbt.func_74775_l("Fuel"));
        this.currentItemBurnTime = this.getItemBurnTime(this.getFuelItem());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbt.func_74782_a("Input", (NBTBase)this.inputInventory.serializeNBT());
        nbt.func_74782_a("Output", (NBTBase)this.outputInventory.serializeNBT());
        nbt.func_74782_a("Fuel", (NBTBase)this.fuelInv.serializeNBT());
        return nbt;
    }

    @Override
    public double acceptEMC(@Nonnull EnumFacing side, double toAccept) {
        if (this.getStoredEmc() < (double)1.6f) {
            double needed = (double)1.6f - this.getStoredEmc();
            double accept = Math.min(needed, toAccept);
            this.addEMC(accept);
            return accept;
        }
        return 0.0;
    }
}

