/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldTransmuteRecipeWrapper
implements IRecipeWrapper {
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final List<FluidStack> fluidInput;
    private final List<FluidStack> fluidOutput;

    public WorldTransmuteRecipeWrapper(WorldTransmutations.Entry recipe) {
        Block b = recipe.input.func_177230_c();
        if (FluidRegistry.lookupFluidForBlock((Block)b) != null) {
            this.input = ImmutableList.of();
            this.fluidInput = ImmutableList.of((Object)new FluidStack(FluidRegistry.lookupFluidForBlock((Block)b), 1000));
        } else {
            this.input = ImmutableList.of((Object)ItemHelper.stateToStack(recipe.input, 1));
            this.fluidInput = ImmutableList.of();
        }
        ImmutableList.Builder outStackBuilder = ImmutableList.builder();
        ImmutableList.Builder outFluidBuilder = ImmutableList.builder();
        for (IBlockState output : new IBlockState[]{(IBlockState)recipe.outputs.getLeft(), (IBlockState)recipe.outputs.getRight()}) {
            if (output == null) continue;
            b = output.func_177230_c();
            if (FluidRegistry.lookupFluidForBlock((Block)b) != null) {
                outFluidBuilder.add((Object)new FluidStack(FluidRegistry.lookupFluidForBlock((Block)b), 1000));
                continue;
            }
            outStackBuilder.add((Object)ItemHelper.stateToStack(output, 1));
        }
        this.output = outStackBuilder.build();
        this.fluidOutput = outFluidBuilder.build();
    }

    public List<ItemStack> getInputs() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.output;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInput;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutput;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

