/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import moze_intel.projecte.network.commands.ChangelogCMD;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;

public class ThreadCheckUpdate
extends Thread {
    private static boolean hasRunServer = false;
    private static boolean hasRunClient = false;
    private static final String changelogURL = "https://raw.githubusercontent.com/sinkillerj/ProjectE/master/ChangelogMC110.txt";
    private static final String curseURL = "http://minecraft.curseforge.com/mc-mods/226410-projecte/files";
    private final boolean isServerSide;

    public ThreadCheckUpdate(boolean isServer) {
        this.isServerSide = isServer;
        this.setName("ProjectE Update Checker " + (isServer ? "Server" : "Client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        try {
            connection = (HttpURLConnection)new URL(changelogURL).openConnection();
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                PELogger.logFatal("Update check failed!");
                throw new IOException("No data from github changelog!");
            }
            ArrayList changes = Lists.newArrayList();
            String latestVersion = line.substring(11);
            latestVersion = latestVersion.trim();
            while ((line = reader.readLine()) != null && !line.startsWith("###Version")) {
                if (line.isEmpty()) continue;
                line = line.substring(1).trim();
                changes.add(line);
            }
            if (!"1.10.2-PE1.0.6B".equals(latestVersion)) {
                PELogger.logInfo("Mod is outdated! Check http://minecraft.curseforge.com/mc-mods/226410-projecte/files to get the latest version (" + latestVersion + ").");
                for (String s : changes) {
                    PELogger.logInfo(s);
                }
                if (this.isServerSide) {
                    ChangelogCMD.changelog.addAll(changes);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"pe.update.available", (Object[])new Object[]{latestVersion})));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"pe.update.getit", (Object[])new Object[0])));
                    TextComponentString link = new TextComponentString(curseURL);
                    link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, curseURL));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)link);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"pe.update.changelog", (Object[])new Object[0])));
                }
            } else {
                PELogger.logInfo("Mod is updated.");
            }
        }
        catch (Exception e) {
            PELogger.logFatal("Caught exception in Update Checker thread!");
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    PELogger.logFatal("Caught exception in Update Checker thread!");
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
            if (this.isServerSide) {
                hasRunServer = true;
            } else {
                hasRunClient = true;
            }
        }
    }

    public static boolean hasRunServer() {
        return hasRunServer;
    }

    public static boolean hasRunClient() {
        return hasRunClient;
    }
}

