/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHelper {
    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77989_b((ItemStack)ItemHelper.getNormalizedStack(stack1), (ItemStack)ItemHelper.getNormalizedStack(stack2));
    }

    public static boolean areItemStacksEqualIgnoreNBT(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static boolean basicAreStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static void compactInventory(IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i) == null) continue;
            temp.add(inventory.getStackInSlot(i));
            inventory.setStackInSlot(i, null);
        }
        for (ItemStack s : temp) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)s, (boolean)false);
        }
    }

    public static void compactItemList(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                ItemStack s1 = list.get(j);
                if (!ItemHelper.areItemStacksEqual(s, s1)) continue;
                if (s.field_77994_a + s1.field_77994_a <= s.func_77976_d()) {
                    s.field_77994_a += s1.field_77994_a;
                    s1.field_77994_a = 0;
                    continue;
                }
                s1.field_77994_a = s1.field_77994_a + s.field_77994_a - s.func_77976_d();
                s.field_77994_a = s.func_77976_d();
            }
        }
        Collections.sort(list, Comparators.ITEMSTACK_ASCENDING);
        ItemHelper.trimItemList(list);
    }

    public static void compactItemListNoStacksize(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                ItemStack s1 = list.get(j);
                if (!ItemHelper.areItemStacksEqual(s, s1)) continue;
                s.field_77994_a += s1.field_77994_a;
                s1.field_77994_a = 0;
            }
        }
        Collections.sort(list, Comparators.ITEMSTACK_ASCENDING);
        ItemHelper.trimItemList(list);
    }

    public static boolean containsItemStack(List<ItemStack> list, ItemStack toSearch) {
        for (ItemStack stack : list) {
            if (stack == null || !stack.func_77973_b().equals(toSearch.func_77973_b()) || stack.func_77981_g() && stack.func_77952_i() != toSearch.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getNormalizedStack(ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        result.field_77994_a = 1;
        return result;
    }

    public static List<ItemStack> getODItems(String oreName) {
        ArrayList result = Lists.newArrayList();
        block2: for (ItemStack stack : OreDictionary.getOres((String)oreName)) {
            if (stack == null) continue;
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                ArrayList list = Lists.newArrayList();
                ItemStack copy = stack.func_77946_l();
                copy.func_77964_b(0);
                list.add(copy.func_77946_l());
                String startName = copy.func_77977_a();
                for (int i = 1; i <= 128; ++i) {
                    block6: {
                        try {
                            copy.func_77964_b(i);
                            if (copy.func_77977_a() == null || copy.func_77977_a().equals(startName)) {
                                result.addAll(list);
                            }
                            break block6;
                        }
                        catch (Exception e) {
                            PELogger.logFatal("Couldn't retrieve OD items for: " + oreName);
                            PELogger.logFatal("Caused by: " + e.toString());
                            result.addAll(list);
                        }
                        continue block2;
                    }
                    list.add(copy.func_77946_l());
                    if (i != 128) continue;
                    copy.func_77964_b(0);
                    result.add(copy);
                }
                continue;
            }
            result.add(stack.func_77946_l());
        }
        return result;
    }

    public static String getOreDictionaryName(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return "Unknown";
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIds.length == 0) {
            return "Unknown";
        }
        return OreDictionary.getOreName((int)oreIds[0]);
    }

    public static ItemStack getStackFromString(String internal, int metaData) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(internal));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, metaData);
    }

    public static boolean hasSpace(ItemStack[] inv, ItemStack stack) {
        for (ItemStack invStack : inv) {
            if (invStack == null) {
                return true;
            }
            if (!ItemHelper.areItemStacksEqual(stack, invStack) || invStack.field_77994_a >= invStack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public static IItemHandlerModifiable immutableCopy(IItemHandler toCopy) {
        final ArrayList<ItemStack> list = new ArrayList<ItemStack>(toCopy.getSlots());
        for (int i = 0; i < toCopy.getSlots(); ++i) {
            list.add(toCopy.getStackInSlot(i));
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, ItemStack stack) {
            }

            public int getSlots() {
                return list.size();
            }

            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)list.get(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return null;
            }
        };
    }

    public static boolean invContainsItem(IItemHandler inv, ItemStack toSearch) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || !ItemHelper.basicAreStacksEqual(stack, toSearch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOre(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150439_ay) {
            return true;
        }
        if (Item.func_150898_a((Block)state.func_177230_c()) == null) {
            return false;
        }
        String oreDictName = ItemHelper.getOreDictionaryName(ItemHelper.stateToStack(state, 1));
        return oreDictName.startsWith("ore") || oreDictName.startsWith("denseore");
    }

    public static IBlockState stackToState(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).field_150939_a.func_176203_a(stack.func_77960_j());
        }
        return null;
    }

    public static ItemStack stateToStack(IBlockState state, int stackSize) {
        return new ItemStack(state.func_177230_c(), stackSize, state.func_177230_c().func_176201_c(state));
    }

    public static ItemStack stateToDroppedStack(IBlockState state, int stackSize) {
        return new ItemStack(state.func_177230_c(), stackSize, state.func_177230_c().func_180651_a(state));
    }

    private static void trimItemList(List<ItemStack> list) {
        Iterator<ItemStack> iter = list.iterator();
        while (iter.hasNext()) {
            ItemStack s = iter.next();
            if (s.field_77994_a > 0) continue;
            iter.remove();
        }
    }
}

