/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, float drawScale, InGameMapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showPets = mapProperties.showPets.get();
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            String playername = ForgeHelper.INSTANCE.getEntityName((Entity)FMLClientHandler.instance().getClient().field_71439_g);
            TextureCache tc = TextureCache.instance();
            String iconSetName = mapProperties.entityIconSetName.get();
            for (EntityDTO dto : entityDTOs) {
                EntityLivingBase entityLiving = (EntityLivingBase)dto.entityLivingRef.get();
                if (entityLiving == null) continue;
                try {
                    DrawEntityStep drawStep;
                    TextureImpl entityIcon;
                    boolean isPet;
                    boolean bl = isPet = !Strings.isNullOrEmpty((String)dto.owner);
                    if (!showPets && isPet || !showAnimals && dto.passiveAnimal && (!isPet || !showPets) || grid.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean isPlayer = entityLiving instanceof EntityPlayer;
                    TextureImpl locatorImg = dto.hostile != false ? tc.getHostileLocator() : (!Strings.isNullOrEmpty((String)dto.owner) && playername.equals(dto.owner) ? tc.getPetLocator() : (isPlayer ? tc.getOtherLocator() : tc.getNeutralLocator()));
                    if (isPlayer) {
                        entityIcon = tc.getPlayerSkin(ForgeHelper.INSTANCE.getEntityName((Entity)entityLiving));
                        drawStep = DataCache.instance().getDrawEntityStep(entityLiving);
                        drawStep.update(false, locatorImg, entityIcon, showPlayerHeading);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    entityIcon = tc.getEntityIconTexture(iconSetName, dto.filename);
                    if (entityIcon == null) continue;
                    drawStep = DataCache.instance().getDrawEntityStep(entityLiving);
                    drawStep.update(false, locatorImg, entityIcon, showMobHeading);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

