/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.io.MapSaver;
import journeymap.client.model.MapType;
import journeymap.client.service.BaseService;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class ActionService
extends BaseService {
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static final long serialVersionUID = 4412225358529161454L;
    private static boolean debug = true;

    @Override
    public String path() {
        return "/action";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        String type;
        Query query = event.query();
        query.parse();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        WorldClient theWorld = minecraft.field_71441_e;
        if (theWorld == null) {
            this.throwEventException(503, "World not connected", event, false);
        }
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.throwEventException(503, "JourneyMap not mapping", event, false);
        }
        if ("savemap".equals(type = this.getParameter(query, "type", (String)null))) {
            this.saveMap(event);
        } else if ("automap".equals(type)) {
            this.autoMap(event);
        } else {
            String error = "Bad request: type=" + type;
            this.throwEventException(400, error, event, true);
        }
    }

    private void saveMap(Event event) throws Event, Exception {
        Query query = event.query();
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        WorldClient theWorld = minecraft.field_71441_e;
        try {
            MapSaver mapSaver;
            String error;
            File worldDir = FileHandler.getJMWorldDir(minecraft);
            if (!worldDir.exists() || !worldDir.isDirectory()) {
                String error2 = "World unknown: " + worldDir.getAbsolutePath();
            }
            Integer vSlice = this.getParameter((Map<String, String[]>)query, "depth", (Integer)null);
            int dimension = this.getParameter((Map<String, String[]>)query, "dim", 0);
            String mapTypeString = this.getParameter(query, "mapType", MapType.Name.day.name());
            MapType mapType = null;
            MapType.Name mapTypeName = null;
            try {
                mapTypeName = MapType.Name.valueOf(mapTypeString);
            }
            catch (Exception e) {
                error = "Bad request: mapType=" + mapTypeString;
                this.throwEventException(400, error, event, true);
            }
            if (mapTypeName != MapType.Name.underground) {
                vSlice = null;
            }
            Boolean hardcore = theWorld.func_72912_H().func_76093_s();
            if (mapType.isUnderground() && hardcore.booleanValue()) {
                error = "Cave mapping on hardcore servers is not allowed";
                this.throwEventException(403, error, event, true);
            }
            if (!(mapSaver = new MapSaver(worldDir, mapType)).isValid()) {
                this.throwEventException(403, "No image files to save.", event, true);
            }
            JourneymapClient.getInstance().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
            Properties response = new Properties();
            response.put("filename", mapSaver.getSaveFileName());
            this.respondJson(event, response);
        }
        catch (NumberFormatException e) {
            this.reportMalformedRequest(event);
        }
        catch (Event eventEx) {
            throw eventEx;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            this.throwEventException(500, "Unexpected error handling path: " + this.path, event, true);
        }
    }

    private void autoMap(Event event) throws Event, Exception {
        boolean enabled = JourneymapClient.getInstance().isTaskManagerEnabled(MapRegionTask.Manager.class);
        String scope = this.getParameter(event.query(), "scope", "stop");
        HashMap<String, String> responseObj = new HashMap<String, String>();
        if ("stop".equals(scope)) {
            if (enabled) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, false, Boolean.FALSE);
                responseObj.put("message", "automap_complete");
            }
        } else if (!enabled) {
            boolean doAll = "all".equals(scope);
            JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, true, doAll);
            responseObj.put("message", "automap_started");
        } else {
            responseObj.put("message", "automap_already_started");
        }
        this.respondJson(event, responseObj);
    }
}

