/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.migrate;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.properties.ClientPropertiesBase;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.MigrationTask;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.version.Version;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate5_2
implements MigrationTask {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final transient Gson gson = new GsonBuilder().setPrettyPrinting().create();
    Logger logger = LogManager.getLogger((String)"journeymap");

    @Override
    public boolean isActive(Version currentVersion) {
        if (currentVersion.toMajorMinorString().equals("5.2")) {
            String optionsManagerViewed;
            if (JourneymapClient.getCoreProperties() == null) {
                JourneymapClient.getInstance().loadConfigProperties();
            }
            if (Strings.isNullOrEmpty((String)(optionsManagerViewed = JourneymapClient.getCoreProperties().optionsManagerViewed.get()))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean call() throws Exception {
        return this.migrateConfigs();
    }

    private boolean migrateConfigs() {
        try {
            String path5_1 = Joiner.on((String)File.separator).join((Object)Constants.JOURNEYMAP_DIR, (Object)"config", new Object[]{"5.1"});
            File legacyConfigDir = new File(FileHandler.MinecraftDirectory, path5_1);
            if (!legacyConfigDir.canRead()) {
                return true;
            }
            this.logger.info("Migrating configs from 5.1 to 5.2");
            List<ClientPropertiesBase> propertiesList = Arrays.asList(JourneymapClient.getCoreProperties(), JourneymapClient.getFullMapProperties(), JourneymapClient.getMiniMapProperties(1), JourneymapClient.getMiniMapProperties(2), JourneymapClient.getWaypointProperties(), JourneymapClient.getWebMapProperties());
            for (PropertiesBase propertiesBase : propertiesList) {
                File oldConfigfile = new File(legacyConfigDir, propertiesBase.getFile().getName());
                if (!oldConfigfile.canRead()) continue;
                try {
                    propertiesBase.load(oldConfigfile, false);
                    propertiesBase.save();
                }
                catch (Throwable t) {
                    this.logger.error(String.format("Unexpected error in migrateConfigs(): %s", LogFormatter.toString(t)));
                }
            }
            JourneymapClient.getCoreProperties().optionsManagerViewed.set("5.1");
            return true;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected error in migrateConfigs(): %s", LogFormatter.toString(t)));
            return false;
        }
    }
}

